/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.encoding.impl;

import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.AbstractHttpServletResponseMessageEncoder;

public class SimpleNimbusResponseEncoder
extends AbstractHttpServletResponseMessageEncoder {
    public SimpleNimbusResponseEncoder() {
        this.setProtocolMessageLoggerSubCategory("OAUTH2");
    }

    protected void doEncode() throws MessageEncodingException {
        if (!(this.getMessageContext().getMessage() instanceof Response)) {
            throw new MessageEncodingException("Incorrect message type");
        }
        try {
            HttpServletResponse response = this.getHttpServletResponse();
            HTTPResponse resp = ((Response)this.getMessageContext().ensureMessage()).toHTTPResponse();
            JakartaServletUtils.applyHTTPResponse((HTTPResponse)resp, (HttpServletResponse)response);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem encoding response", (Exception)e);
        }
    }

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        if (message instanceof Response) {
            Response response = (Response)message;
            return response.toString();
        }
        return null;
    }
}

