/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.encoding.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OAuthAuthorizationRequest;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.encoding.AuthenticationContextClassReferenceSupport;
import net.shibboleth.oidc.profile.encoding.OIDCMessageEncoder;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.net.URLBuilder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.AbstractHttpServletResponseMessageEncoder;
import org.slf4j.Logger;

public abstract class AbstractOIDCMessageEncoder
extends AbstractHttpServletResponseMessageEncoder
implements OIDCMessageEncoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCMessageEncoder.class);
    @Nonnull
    private Predicate<List<Pair<String, String>>> authorizationParamsAreValidPredicate = PredicateSupport.alwaysTrue();

    protected AbstractOIDCMessageEncoder() {
        this.setProtocolMessageLoggerSubCategory("OAUTH2");
    }

    public void setAuthorizationParamsAreValidPredicate(@Nullable Predicate<List<Pair<String, String>>> predicate) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        if (predicate != null) {
            this.authorizationParamsAreValidPredicate = predicate;
        }
    }

    protected void serializeAuthorizationParamsToUrl(@Nonnull OIDCAuthenticationRequest request, @Nonnull URLBuilder builder) throws MessageEncodingException {
        List<Pair<String, String>> params = this.createParametersFromRequest(request);
        params.forEach(param -> builder.getQueryParams().add(param));
    }

    protected String serializeAuthorizationParamsToQueryString(@Nonnull OIDCAuthenticationRequest request) throws MessageEncodingException {
        URLBuilder builder = new URLBuilder();
        List<Pair<String, String>> params = this.createParametersFromRequest(request);
        params.forEach(param -> builder.getQueryParams().add(param));
        return builder.buildQueryString();
    }

    @Nonnull
    protected List<Pair<String, String>> createParametersFromRequest(@Nonnull OIDCAuthenticationRequest req) throws MessageEncodingException {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        if (req.getRequestObject() != null) {
            this.createParametersFromRequestWithRequestObject(params, req);
        } else {
            this.createParametersFromRequestWithoutRequestObject(params, req);
        }
        return params;
    }

    private void createStandardOAuthParameters(@Nonnull List<Pair<String, String>> params, @Nonnull OIDCAuthenticationRequest req) {
        params.add((Pair<String, String>)new Pair((Object)"client_id", (Object)req.getClientID().getValue()));
        ResponseType type = req.getResponseType();
        if (type != null) {
            params.add((Pair<String, String>)new Pair((Object)"response_type", (Object)type.toString()));
        }
        params.add((Pair<String, String>)new Pair((Object)"scope", (Object)req.getScope().toString()));
        ResponseMode mode = req.getResponseMode();
        if (mode != null && !mode.equals((Object)req.getDefaultResponseMode())) {
            params.add((Pair<String, String>)new Pair((Object)"response_mode", (Object)mode.getValue()));
        }
        OAuthAuthorizationRequest.CodeChallengeMethod codeChallengedMethod = req.getCodeChallengeMethod();
        if (req.getCodeChallenge() != null && codeChallengedMethod != null) {
            params.add((Pair<String, String>)new Pair((Object)"code_challenge", (Object)req.getCodeChallenge()));
            params.add((Pair<String, String>)new Pair((Object)"code_challenge_method", (Object)codeChallengedMethod.getValue()));
        }
    }

    private void createParametersFromRequestWithRequestObject(@Nonnull List<Pair<String, String>> params, @Nonnull OIDCAuthenticationRequest req) throws MessageEncodingException {
        this.createStandardOAuthParameters(params, req);
        JWT reqObject = req.getRequestObject();
        if (reqObject != null) {
            try {
                params.add((Pair<String, String>)new Pair((Object)"request", (Object)reqObject.serialize()));
            }
            catch (IllegalStateException e) {
                throw new MessageEncodingException("Couldn't serialize request object to JWT: " + e.getMessage(), (Exception)e);
            }
        }
        if (!this.validateParams(params)) {
            throw new MessageEncodingException("Authorization parameters are not valid");
        }
    }

    private void createParametersFromRequestWithoutRequestObject(@Nonnull List<Pair<String, String>> params, @Nonnull OIDCAuthenticationRequest req) throws MessageEncodingException {
        Display display;
        Duration maxage;
        Nonce nonce;
        Prompt prompt;
        State state;
        this.createStandardOAuthParameters(params, req);
        URI redirectURI = req.getRedirectURI();
        if (redirectURI != null) {
            params.add((Pair<String, String>)new Pair((Object)"redirect_uri", (Object)redirectURI.toString()));
        }
        if ((state = req.getState()) != null) {
            params.add((Pair<String, String>)new Pair((Object)"state", (Object)state.getValue()));
        }
        if ((prompt = req.getPrompt()) != null) {
            params.add((Pair<String, String>)new Pair((Object)"prompt", (Object)prompt.toString()));
        }
        if ((nonce = req.getNonce()) != null) {
            params.add((Pair<String, String>)new Pair((Object)"nonce", (Object)nonce.getValue()));
        }
        if ((maxage = req.getMaxAge()) != null) {
            params.add((Pair<String, String>)new Pair((Object)"max_age", (Object)Long.toString(maxage.toSeconds())));
        }
        if ((display = req.getDisplay()) != null) {
            params.add((Pair<String, String>)new Pair((Object)"display", (Object)display.toString()));
        }
        if (req.getLoginHint() != null) {
            params.add((Pair<String, String>)new Pair((Object)"login_hint", (Object)req.getLoginHint()));
        }
        if (req.providerSupportsClaimsParameter()) {
            AuthenticationContextClassReferenceSupport.buildACRClaimsRequest((OIDCAuthenticationRequest)req);
            OIDCClaimsRequest claimsReq = req.getRequestedClaims();
            if (claimsReq != null) {
                params.add((Pair<String, String>)new Pair((Object)"claims", (Object)claimsReq.toJSONString()));
            }
        }
        if (!req.providerSupportsClaimsParameter() && req.getAcrs() != null && !req.getAcrs().isEmpty()) {
            String acrString = String.join((CharSequence)" ", req.getAcrs().stream().map(Identifier::getValue).toList());
            params.add((Pair<String, String>)new Pair((Object)"acr_values", (Object)acrString));
        }
        if (!this.validateParams(params)) {
            throw new MessageEncodingException("Authorization parameters are not valid");
        }
    }

    protected boolean validateParams(@Nonnull List<Pair<String, String>> params) {
        if (!this.authorizationParamsAreValidPredicate.test(params)) {
            return false;
        }
        if (!this.pairFirstEquals("response_type", params)) {
            this.log.error("Authorization request parameters are invalid, no response_type");
            return false;
        }
        if (!this.pairFirstEquals("client_id", params)) {
            this.log.error("Authorization request parameters are invalid, no client_id");
            return false;
        }
        if (!this.pairFirstEquals("scope", params)) {
            this.log.error("Authorization request parameters are invalid, no scope");
            return false;
        }
        if (!this.pairSecondContains("scope", "openid", params)) {
            this.log.error("Authorization request parameters are invalid, scope does not contain 'openid'");
            return false;
        }
        return true;
    }

    private boolean pairFirstEquals(@Nonnull String value, @Nonnull List<Pair<String, String>> params) {
        return params.stream().map(Pair::getFirst).anyMatch(key -> key.equals(value));
    }

    private boolean pairSecondContains(@Nonnull String key, @Nonnull String value, List<Pair<String, String>> params) {
        Optional<Pair> pairByKey = params.stream().filter(p -> key.equals(p.getFirst())).findFirst();
        if (pairByKey.isEmpty()) {
            return false;
        }
        String second = (String)pairByKey.get().getSecond();
        if (second == null) {
            return false;
        }
        return second.contains(value);
    }

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        if (message instanceof OIDCAuthenticationRequest) {
            OIDCAuthenticationRequest authnRequest = (OIDCAuthenticationRequest)message;
            try {
                List<Pair<String, String>> params = this.createParametersFromRequest(authnRequest);
                String paramsSerialized = params.stream().map(p -> (String)p.getFirst() + "=" + (String)p.getSecond()).collect(Collectors.joining(", "));
                return "OIDCAuthenticationRequest{" + paramsSerialized + "}";
            }
            catch (MessageEncodingException e) {
                this.log.trace("Unable to generate serialized message for logging '{}'", (Object)e.getMessage());
            }
        }
        return null;
    }
}

