/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.impl;

import java.security.Principal;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationRelyingPartyProfileConfiguration;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.oidc.profile.config.impl.AbstractOIDCSSOConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2AuthorizationProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOIDCAuthorizationConfiguration
extends AbstractOIDCSSOConfiguration
implements OIDCAuthenticationRelyingPartyProfileConfiguration,
OIDCAuthorizationConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oidc.authorize";
    @Nonnull
    private Predicate<ProfileRequestContext> acrRequestAlwaysEssentialPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> encodeConsentInTokensPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Duration> authorizeCodeLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> encodedAttributesLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> useRequestObjectPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> signRequestObjectPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> encryptRequestObjectPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> deniedUserInfoAttributesLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> includeIssuerInResponsePredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> retrieveUserInfoEndpointClaims;
    @Nonnull
    private Function<ProfileRequestContext, String> redirectUriOverrideLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> responseTypeLookupStrategy = FunctionSupport.constant((Object)"code");
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> scopesLookupStrategy = FunctionSupport.constant(Set.of("openid"));
    @Nonnull
    private Function<ProfileRequestContext, Function<Collection<String>, Collection<Principal>>> acrTranslationStrategyLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Function<Collection<String>, Collection<Principal>>> amrTranslationStrategyLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> proxiedAuthnInstantPredicate;
    @Nonnull
    private Function<ProfileRequestContext, String> httpRequestMethodLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> authorizationCodeClaimsSetManipulationStrategyLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> maxAuthenticationAgeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> loginHintLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> userInfoHttpRequestMethodLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> responseModeLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> tlsServerValidationOnlyPredicate;
    @Nonnull
    private Function<ProfileRequestContext, String> displayLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> responseModesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Predicate<ProfileRequestContext>> requireAuthenticationRequestPredicateLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> requireDpopJktPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> requirePushedAuthorizationRequestPredicate;

    public DefaultOIDCAuthorizationConfiguration() {
        this("http://shibboleth.net/ns/profiles/oidc/sso/browser");
    }

    public DefaultOIDCAuthorizationConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.signRequestObjectPredicate = PredicateSupport.alwaysTrue();
        this.encryptRequestObjectPredicate = PredicateSupport.alwaysFalse();
        this.retrieveUserInfoEndpointClaims = PredicateSupport.alwaysTrue();
        this.proxiedAuthnInstantPredicate = PredicateSupport.alwaysTrue();
        this.acrTranslationStrategyLookupStrategy = FunctionSupport.constant(null);
        this.amrTranslationStrategyLookupStrategy = FunctionSupport.constant(null);
        this.acrRequestAlwaysEssentialPredicate = PredicateSupport.alwaysFalse();
        this.encodeConsentInTokensPredicate = PredicateSupport.alwaysFalse();
        this.useRequestObjectPredicate = PredicateSupport.alwaysFalse();
        this.authorizeCodeLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(5L));
        this.encodedAttributesLookupStrategy = FunctionSupport.constant(null);
        this.deniedUserInfoAttributesLookupStrategy = FunctionSupport.constant(null);
        this.httpRequestMethodLookupStrategy = FunctionSupport.constant((Object)OAuth2AuthorizationProfileConfiguration.HttpRequestMethod.GET.toString());
        this.includeIssuerInResponsePredicate = PredicateSupport.alwaysFalse();
        this.authorizationCodeClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);
        this.maxAuthenticationAgeLookupStrategy = FunctionSupport.constant(null);
        this.loginHintLookupStrategy = FunctionSupport.constant(null);
        this.userInfoHttpRequestMethodLookupStrategy = FunctionSupport.constant((Object)OAuth2AuthorizationProfileConfiguration.HttpRequestMethod.GET.toString());
        this.responseModeLookupStrategy = FunctionSupport.constant(null);
        this.tlsServerValidationOnlyPredicate = PredicateSupport.alwaysFalse();
        this.displayLookupStrategy = FunctionSupport.constant(null);
        this.responseModesLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.emptySet());
        this.requireAuthenticationRequestPredicateLookupStrategy = FunctionSupport.constant((Object)PredicateSupport.alwaysTrue());
        this.requireDpopJktPredicate = PredicateSupport.alwaysFalse();
        this.requirePushedAuthorizationRequestPredicate = PredicateSupport.alwaysFalse();
    }

    public boolean isAcrRequestAlwaysEssential(@Nullable ProfileRequestContext profileRequestContext) {
        return this.acrRequestAlwaysEssentialPredicate.test(profileRequestContext);
    }

    public void setAcrRequestAlwaysEssential(boolean flag) {
        this.acrRequestAlwaysEssentialPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setAcrRequestAlwaysEssentialPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.acrRequestAlwaysEssentialPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isUseRequestObject(@Nullable ProfileRequestContext profileRequestContext) {
        return this.useRequestObjectPredicate.test(profileRequestContext);
    }

    public void setUseRequestObject(boolean flag) {
        this.useRequestObjectPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setUseRequestObjectPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.useRequestObjectPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Use request object condition cannot be null");
    }

    public boolean isEncodeConsentInTokens(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encodeConsentInTokensPredicate.test(profileRequestContext);
    }

    public void setEncodeConsentInTokens(boolean flag) {
        this.encodeConsentInTokensPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setEncodeConsentInTokensPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encodeConsentInTokensPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isRetrieveUserInfoEndpointClaims(@Nonnull ProfileRequestContext profileRequestContext) {
        return this.retrieveUserInfoEndpointClaims.test(profileRequestContext);
    }

    public void setRetrieveUserInfoEndpointClaims(boolean flag) {
        this.retrieveUserInfoEndpointClaims = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    @Deprecated(since="3.3.0", forRemoval=true)
    public void setRetrieveUserInfoEndpointClaims(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.setRetrieveUserInfoEndpointClaimsPredicate(condition);
    }

    public void setRetrieveUserInfoEndpointClaimsPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.retrieveUserInfoEndpointClaims = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isSignRequestObject(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signRequestObjectPredicate.test(profileRequestContext);
    }

    public void setSignRequestObject(boolean flag) {
        this.signRequestObjectPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setSignRequestObjectPredicate(Predicate<ProfileRequestContext> condition) {
        this.signRequestObjectPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isEncryptRequestObject(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptRequestObjectPredicate.test(profileRequestContext);
    }

    public void setEncryptRequestObject(boolean flag) {
        this.encryptRequestObjectPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setEncryptRequestObjectPredicate(Predicate<ProfileRequestContext> condition) {
        this.encryptRequestObjectPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setRedirectUriOverrideLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.redirectUriOverrideLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy can not be null");
    }

    public void setRedirectUriOverride(@Nullable String uri) {
        this.redirectUriOverrideLookupStrategy = uri != null ? FunctionSupport.constant((Object)uri) : FunctionSupport.constant(null);
    }

    public String getRedirectUriOverride(@Nullable ProfileRequestContext profileRequestContext) {
        return this.redirectUriOverrideLookupStrategy.apply(profileRequestContext);
    }

    @Nonnull
    @Positive
    public Duration getAuthorizeCodeLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.authorizeCodeLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Authorization code lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setAuthorizeCodeLifetime(@Nonnull @Positive Duration lifetime) {
        Duration codeLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Authorization code lifetime cannot be null");
        Constraint.isTrue((!codeLifetime.isZero() && !codeLifetime.isNegative() ? 1 : 0) != 0, (String)"Authorization code lifetime must be greater than 0");
        this.authorizeCodeLifetimeLookupStrategy = FunctionSupport.constant((Object)codeLifetime);
    }

    public void setAuthorizeCodeLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.authorizeCodeLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setHttpRequestMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.httpRequestMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"HTTP request method strategy can not be null");
    }

    public void setHttpRequestMethod(@Nullable OAuth2AuthorizationProfileConfiguration.HttpRequestMethod method) {
        this.httpRequestMethodLookupStrategy = FunctionSupport.constant((Object)(method != null ? method.toString() : null));
    }

    public OAuth2AuthorizationProfileConfiguration.HttpRequestMethod getHttpRequestMethod(@Nullable ProfileRequestContext profileRequestContext) {
        String method = this.httpRequestMethodLookupStrategy.apply(profileRequestContext);
        if (method != null) {
            try {
                return OAuth2AuthorizationProfileConfiguration.HttpRequestMethod.valueOf((String)method);
            }
            catch (IllegalArgumentException e) {
                throw new ConstraintViolationException("Unexpected HTTP method value: '" + method + "': " + e.getMessage());
            }
        }
        return null;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getEncodedAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> attributes = this.encodedAttributesLookupStrategy.apply(profileRequestContext);
        if (attributes != null) {
            return CollectionSupport.copyToSet(attributes);
        }
        return CollectionSupport.emptySet();
    }

    public void setEncodedAttributes(@Nullable @NonnullElements Collection<String> attributes) {
        this.encodedAttributesLookupStrategy = attributes == null || attributes.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(attributes)));
    }

    public void setEncodedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.encodedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getDeniedUserInfoAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> attributes = this.deniedUserInfoAttributesLookupStrategy.apply(profileRequestContext);
        if (attributes != null) {
            return CollectionSupport.copyToSet(attributes);
        }
        return CollectionSupport.emptySet();
    }

    public void setDeniedUserInfoAttributes(@Nullable @NonnullElements Collection<String> attributes) {
        this.deniedUserInfoAttributesLookupStrategy = attributes == null || attributes.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(attributes)));
    }

    public void setDeniedUserInfoAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.deniedUserInfoAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isIncludeIssuerInResponse(@Nullable ProfileRequestContext profileRequestContext) {
        return this.includeIssuerInResponsePredicate.test(profileRequestContext);
    }

    public void setIncludeIssuerInResponse(boolean flag) {
        this.includeIssuerInResponsePredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setIncludeIssuerInResponsePredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeIssuerInResponsePredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setResponseTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.responseTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ResponseType lookup strategy can not be null");
    }

    public void setResponseType(@Nullable String responseType) {
        this.responseTypeLookupStrategy = FunctionSupport.constant((Object)responseType);
    }

    public String getResponseType(@Nullable ProfileRequestContext profileRequestContext) {
        return this.responseTypeLookupStrategy.apply(profileRequestContext);
    }

    @Nullable
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getAuthorizationCodeClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authorizationCodeClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setAuthorizationCodeClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.authorizationCodeClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setAuthorizationCodeClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.authorizationCodeClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setScopesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.scopesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Scopes lookup strategy can not be null");
    }

    public void setScopes(@Nullable @NonnullElements Set<String> scopes) {
        this.scopesLookupStrategy = scopes == null || scopes.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(scopes)));
    }

    @Nullable
    public Set<String> getScopes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.scopesLookupStrategy.apply(profileRequestContext);
    }

    public void setAuthenticationMethodsReferencesTranslationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, Function<Collection<String>, Collection<Principal>>> strategy) {
        this.amrTranslationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Function<Collection<String>, Collection<Principal>> getAuthenticationMethodsReferencesTranslationStrategy(@Nullable ProfileRequestContext prc) {
        return this.amrTranslationStrategyLookupStrategy.apply(prc);
    }

    public void setAuthenticationContextClassReferenceTranslationStrategyLookupStrategy(@Nullable Function<ProfileRequestContext, Function<Collection<String>, Collection<Principal>>> strategy) {
        this.acrTranslationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Function<Collection<String>, Collection<Principal>> getAuthenticationContextClassReferenceTranslationStrategy(@Nullable ProfileRequestContext prc) {
        return this.acrTranslationStrategyLookupStrategy.apply(prc);
    }

    public boolean isProxiedAuthnInstant(@Nullable ProfileRequestContext profileRequestContext) {
        return this.proxiedAuthnInstantPredicate.test(profileRequestContext);
    }

    public void setProxiedAuthnInstant(boolean flag) {
        this.proxiedAuthnInstantPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    @Nullable
    public Duration getMaxAuthenticationAge(@Nullable ProfileRequestContext profileRequestContext) {
        return this.maxAuthenticationAgeLookupStrategy.apply(profileRequestContext);
    }

    public void setMaxAuthenticationAge(@Nonnull @Positive Duration age) {
        Duration maxAge = (Duration)Constraint.isNotNull((Object)age, (String)"Max authentication age cannot be null");
        Constraint.isTrue((!maxAge.isZero() && !maxAge.isNegative() ? 1 : 0) != 0, (String)"Max age must be greater than 0");
        this.maxAuthenticationAgeLookupStrategy = FunctionSupport.constant((Object)maxAge);
    }

    public void setMaxAuthenticationAgeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.maxAuthenticationAgeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setLoginHintLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.loginHintLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Login Hint strategy can not be null");
    }

    public void setLoginHint(@Nonnull @NotEmpty String fixedLoginHint) {
        Constraint.isNotEmpty((String)fixedLoginHint, (String)"Fixed login hint can not be null or empty");
        this.loginHintLookupStrategy = FunctionSupport.constant((Object)fixedLoginHint);
    }

    @Nullable
    public String getLoginHint(@Nullable ProfileRequestContext profileRequestContext) {
        return this.loginHintLookupStrategy.apply(profileRequestContext);
    }

    public void setUserInfoHttpRequestMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.userInfoHttpRequestMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"HTTP request method strategy can not be null");
    }

    public void setUserInfoHttpRequestMethod(@Nullable OAuth2AuthorizationProfileConfiguration.HttpRequestMethod method) {
        this.userInfoHttpRequestMethodLookupStrategy = FunctionSupport.constant((Object)(method != null ? method.toString() : null));
    }

    @Nullable
    public OAuth2AuthorizationProfileConfiguration.HttpRequestMethod getUserInfoHttpRequestMethod(@Nullable ProfileRequestContext profileRequestContext) {
        String method = this.userInfoHttpRequestMethodLookupStrategy.apply(profileRequestContext);
        if (method != null) {
            try {
                return OAuth2AuthorizationProfileConfiguration.HttpRequestMethod.valueOf((String)method);
            }
            catch (IllegalArgumentException e) {
                throw new ConstraintViolationException("Unexpected HTTP method value: '" + method + "': " + e.getMessage());
            }
        }
        return null;
    }

    public void setResponseModeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.responseModeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ResponseMode lookup strategy can not be null");
    }

    public void setResponseMode(@Nonnull String responseMode) {
        this.responseModeLookupStrategy = FunctionSupport.constant((Object)responseMode);
    }

    public String getResponseMode(@Nullable ProfileRequestContext profileRequestContext) {
        return this.responseModeLookupStrategy.apply(profileRequestContext);
    }

    public void setTlsServerValidationSufficient(boolean flag) {
        this.tlsServerValidationOnlyPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    @Deprecated(since="3.3.0", forRemoval=true)
    public void setTlsServerValidationSufficient(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.setTlsServerValidationSufficientPredicate(condition);
    }

    public void setTlsServerValidationSufficientPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.tlsServerValidationOnlyPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isTlsServerValidationSufficient(@Nullable ProfileRequestContext profileRequestContext) {
        return this.tlsServerValidationOnlyPredicate.test(profileRequestContext);
    }

    public void setDisplay(@Nullable String display) {
        this.displayLookupStrategy = FunctionSupport.constant((Object)display);
    }

    public void setDisplayLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.displayLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Display lookup strategy can not be null");
    }

    public String getDisplay(@Nullable ProfileRequestContext profileRequestContext) {
        return this.displayLookupStrategy.apply(profileRequestContext);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getResponseModes(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> responseModes = this.responseModesLookupStrategy.apply(profileRequestContext);
        if (responseModes != null) {
            return CollectionSupport.copyToSet(responseModes);
        }
        return CollectionSupport.emptySet();
    }

    public void setResponseModes(@Nullable @NonnullElements Collection<String> responseModes) {
        this.responseModesLookupStrategy = responseModes == null || responseModes.isEmpty() ? FunctionSupport.constant((Object)CollectionSupport.emptySet()) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(responseModes)));
    }

    public void setResponseModesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.responseModesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isRequireAuthenticationRequest(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requireAuthenticationRequestPredicateLookupStrategy.apply(profileRequestContext).test(profileRequestContext);
    }

    public void setRequireAuthenticationRequest(boolean flag) {
        this.requireAuthenticationRequestPredicateLookupStrategy = FunctionSupport.constant((Object)(flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse()));
    }

    public void setRequireAuthenticationRequestPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.requireAuthenticationRequestPredicateLookupStrategy = FunctionSupport.constant((Object)((Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null")));
    }

    public void setRequireAuthenticationRequestPredicateLookupStrategy(@Nonnull Function<ProfileRequestContext, Predicate<ProfileRequestContext>> strategy) {
        this.requireAuthenticationRequestPredicateLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isRequireDpopJkt(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requireDpopJktPredicate.test(profileRequestContext);
    }

    public void setRequireDpopJkt(boolean flag) {
        this.requireDpopJktPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setRequireDpopJktPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.requireDpopJktPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isRequirePushedAuthorizationRequest(@Nullable ProfileRequestContext profileRequestContext) {
        return this.requirePushedAuthorizationRequestPredicate.test(profileRequestContext);
    }

    public void setRequirePushedAuthorizationRequest(boolean flag) {
        this.requirePushedAuthorizationRequestPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setRequirePushedAuthorizationRequestPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.requirePushedAuthorizationRequestPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }
}

