/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.impl;

import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.OIDCSSOProviderConfiguration;
import net.shibboleth.oidc.profile.config.OIDCSSORelyingPartyConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.impl.AbstractOAuth2FlowAwareProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractOIDCSSOConfiguration
extends AbstractOAuth2FlowAwareProfileConfiguration
implements OIDCSSORelyingPartyConfiguration,
OIDCSSOProviderConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> forcePKCEPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> allowPKCEPlainPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Duration> idTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(1L));
    @Nonnull
    private Function<ProfileRequestContext, String> accessTokenTypeLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> refreshTokenTypeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(10L));
    @Nonnull
    private Function<ProfileRequestContext, Duration> refreshTokenTimeoutLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(2L));
    @Nonnull
    private Function<ProfileRequestContext, Duration> refreshTokenChainLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(2L));
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> assertionAudiencesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> alwaysIncludedAttributesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> idTokenManipulationStrategyLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> accessTokenClaimsSetManipulationStrategyLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiPredicate<URI, ProfileRequestContext>> customRedirectUriValidationStrategyLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> alwaysIssueBearerAccessTokenPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> strictScopeValidationPredicate;

    public AbstractOIDCSSOConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.refreshTokenTypeLookupStrategy = FunctionSupport.constant(null);
        this.assertionAudiencesLookupStrategy = FunctionSupport.constant(null);
        this.alwaysIncludedAttributesLookupStrategy = FunctionSupport.constant(null);
        this.idTokenManipulationStrategyLookupStrategy = FunctionSupport.constant(null);
        this.accessTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);
        this.customRedirectUriValidationStrategyLookupStrategy = FunctionSupport.constant(null);
        this.alwaysIssueBearerAccessTokenPredicate = PredicateSupport.alwaysFalse();
        this.strictScopeValidationPredicate = PredicateSupport.alwaysFalse();
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    public boolean isForcePKCE(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forcePKCEPredicate.test(profileRequestContext);
    }

    public void setForcePKCE(boolean flag) {
        this.forcePKCEPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setForcePKCEPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forcePKCEPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isAllowPKCEPlain(@Nullable ProfileRequestContext profileRequestContext) {
        return this.allowPKCEPlainPredicate.test(profileRequestContext);
    }

    public void setAllowPKCEPlain(boolean flag) {
        this.allowPKCEPlainPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setAllowPKCEPlainPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.allowPKCEPlainPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getIDTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.idTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"ID token lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setIDTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Duration idTokenLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"ID token lifetime cannot be null");
        Constraint.isTrue((!idTokenLifetime.isZero() && !idTokenLifetime.isNegative() ? 1 : 0) != 0, (String)"ID token lifetime must be greater than 0");
        this.idTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)idTokenLifetime);
    }

    public void setIDTokenLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.idTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    @NotEmpty
    public String getAccessTokenType(@Nullable ProfileRequestContext profileRequestContext) {
        return this.accessTokenTypeLookupStrategy.apply(profileRequestContext);
    }

    public void setAccessTokenType(@Nullable @NotEmpty String type) {
        this.accessTokenTypeLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)type));
    }

    public void setAccessTokenTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.accessTokenTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getAccessTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.accessTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setAccessTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Duration tokenLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Access token lifetime cannot be null");
        Constraint.isTrue((!tokenLifetime.isZero() && !tokenLifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        this.accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)tokenLifetime);
    }

    public void setAccessTokenLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.accessTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getRefreshTokenTimeout(@Nullable ProfileRequestContext profileRequestContext) {
        Duration timeout = this.refreshTokenTimeoutLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((timeout != null && !timeout.isZero() && !timeout.isNegative() ? 1 : 0) != 0, (String)"Refresh token timeout must be greater than 0");
        assert (timeout != null);
        return timeout;
    }

    public void setRefreshTokenTimeout(@Nonnull @Positive Duration timeout) {
        Duration tokenTimeout = (Duration)Constraint.isNotNull((Object)timeout, (String)"Refresh token timeout cannot be null");
        Constraint.isTrue((!tokenTimeout.isZero() && !timeout.isNegative() ? 1 : 0) != 0, (String)"Refresh token timeout must be greater than 0");
        this.refreshTokenTimeoutLookupStrategy = FunctionSupport.constant((Object)tokenTimeout);
    }

    public void setRefreshTokenTimeoutLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.refreshTokenTimeoutLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getRefreshTokenChainLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.refreshTokenChainLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Refresh token chain lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setRefreshTokenChainLifetime(@Nonnull @Positive Duration lifetime) {
        Duration chainLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Refresh token chain lifetime cannot be null");
        Constraint.isTrue((!chainLifetime.isZero() && !chainLifetime.isNegative() ? 1 : 0) != 0, (String)"Refresh token chain lifetime must be greater than 0");
        this.refreshTokenChainLifetimeLookupStrategy = FunctionSupport.constant((Object)chainLifetime);
    }

    public void setRefreshTokenChainLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.refreshTokenChainLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    @NotEmpty
    public String getRefreshTokenType(@Nullable ProfileRequestContext profileRequestContext) {
        return this.refreshTokenTypeLookupStrategy.apply(profileRequestContext);
    }

    public void setRefreshTokenType(@Nullable @NotEmpty String type) {
        this.refreshTokenTypeLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)type));
    }

    public void setRefreshTokenTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.refreshTokenTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getAdditionalAudiencesForIdToken(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> audiences = this.assertionAudiencesLookupStrategy.apply(profileRequestContext);
        if (audiences != null) {
            return CollectionSupport.copyToSet(audiences);
        }
        return CollectionSupport.emptySet();
    }

    public void setAdditionalAudiencesForIdToken(@Nullable @NonnullElements Collection<String> audiences) {
        this.assertionAudiencesLookupStrategy = audiences == null || audiences.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(audiences)));
    }

    public void setAdditionalAudiencesForIdTokenLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.assertionAudiencesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getAlwaysIncludedAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> attributes = this.alwaysIncludedAttributesLookupStrategy.apply(profileRequestContext);
        if (attributes != null) {
            return CollectionSupport.copyToSet(attributes);
        }
        return CollectionSupport.emptySet();
    }

    public void setAlwaysIncludedAttributes(@Nullable @NonnullElements Collection<String> attributes) {
        this.alwaysIncludedAttributesLookupStrategy = attributes == null || attributes.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(attributes)));
    }

    public void setAlwaysIncludedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.alwaysIncludedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getIDTokenManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.idTokenManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setIDTokenManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.idTokenManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setIDTokenManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.idTokenManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getAccessTokenClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.accessTokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setAccessTokenClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.accessTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setAccessTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.accessTokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public BiPredicate<URI, ProfileRequestContext> getCustomRedirectUriValidationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.customRedirectUriValidationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setCustomRedirectUriValidationStrategy(@Nullable BiPredicate<URI, ProfileRequestContext> strategy) {
        this.customRedirectUriValidationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setCustomRedirectUriValidationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiPredicate<URI, ProfileRequestContext>> strategy) {
        this.customRedirectUriValidationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isAlwaysIssueBearerAccessToken(@Nullable ProfileRequestContext profileRequestContext) {
        return this.alwaysIssueBearerAccessTokenPredicate.test(profileRequestContext);
    }

    public void setAlwaysIssueBearerAccessToken(boolean flag) {
        this.alwaysIssueBearerAccessTokenPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setAlwaysIssueBearerAccessTokenPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.alwaysIssueBearerAccessTokenPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Always issue bearer access token predicate cannot be null");
    }

    public boolean isStrictScopeValidation(@Nullable ProfileRequestContext profileRequestContext) {
        return this.strictScopeValidationPredicate.test(profileRequestContext);
    }

    public void setStrictScopeValidation(boolean flag) {
        this.strictScopeValidationPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setStrictScopeValidationPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.strictScopeValidationPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Strict scope validation predicate cannot be null");
    }
}

