/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.audit.impl;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.audit.impl.AbstractClaimsSetAuditExtractor;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class DateBasedJWTClaimAuditExtractor
extends AbstractClaimsSetAuditExtractor<String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DateBasedJWTClaimAuditExtractor.class);
    @Nonnull
    private DateTimeFormatter dateTimeFormatter;

    public DateBasedJWTClaimAuditExtractor() {
        DateTimeFormatter isoInstant = DateTimeFormatter.ISO_INSTANT;
        assert (isoInstant != null);
        this.dateTimeFormatter = isoInstant;
    }

    public void setDateTimeFormat(@Nullable @NotEmpty String format) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        String trimmedFormat = StringSupport.trimOrNull((String)format);
        if (trimmedFormat != null) {
            DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(trimmedFormat);
            if (timeFormatter != null) {
                this.dateTimeFormatter = timeFormatter;
            } else {
                this.log.warn("Could not build a formatter from pattern {}", (Object)trimmedFormat);
            }
        }
    }

    @Override
    @Nullable
    protected String doLookup(@Nonnull ClaimsSet claimsSet) throws ParseException {
        Date dateClaim = claimsSet.getDateClaim(this.getClaimName());
        if (dateClaim == null) {
            this.log.trace("Date claim '{}' was null", (Object)this.getClaimName());
            return null;
        }
        try {
            return this.dateTimeFormatter.format(dateClaim.toInstant());
        }
        catch (DateTimeException e) {
            this.log.debug("Unable to format date claim '{}'", (Object)dateClaim, (Object)e);
            return null;
        }
    }
}

