/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.logic.ConstraintViolationException;

public final class MetadataPolicyHelper {
    private MetadataPolicyHelper() {
    }

    public static boolean isSupersetOfValues(@Nonnull Object candidate, @Nonnull Collection<?> values) {
        return candidate instanceof Collection ? ((Collection)candidate).containsAll(values) : values.size() == 1 && values.contains(candidate);
    }

    public static boolean isSubsetOfValues(@Nonnull Object candidate, @Nonnull Collection<?> values) {
        return candidate instanceof Collection ? values.containsAll((Collection)candidate) : values.contains(candidate);
    }

    @Nullable
    public static MetadataPolicy mergeMetadataPolicies(@Nullable MetadataPolicy superior, @Nullable MetadataPolicy subordinate) throws ConstraintViolationException {
        String regexp;
        Object anotherValue;
        Object anotherDefault;
        if (superior == null) {
            return subordinate;
        }
        if (subordinate == null) {
            return superior;
        }
        Object defaultValue = superior.getDefaultValue();
        if (defaultValue != null && (anotherDefault = subordinate.getDefaultValue()) != null && !defaultValue.equals(anotherDefault)) {
            throw new ConstraintViolationException("Merging two default operators is NOT allowed unless the two operator values are equal.");
        }
        Object value = superior.getValue();
        if (value != null && (anotherValue = subordinate.getValue()) != null && !value.equals(anotherValue)) {
            throw new ConstraintViolationException("Merging two value operators is NOT allowed unless the two operator values are equal.");
        }
        try {
            regexp = (String)MetadataPolicyHelper.doMergeForTwoObjects(superior.getRegexp(), subordinate.getRegexp(), false);
        }
        catch (ConstraintViolationException e) {
            throw new ConstraintViolationException("Merging two regexp operators is NOT allowed unless the two operator values are equal.");
        }
        for (String customOperator : superior.getCustomOperators().keySet()) {
            if (!subordinate.getCustomOperators().containsKey(customOperator)) continue;
            Object superiorValue = superior.getCustomOperators().get(customOperator);
            Object subordinateValue = subordinate.getCustomOperators().get(customOperator);
            if ((superiorValue == null || superiorValue.equals(subordinateValue)) && (superiorValue != null || subordinateValue == null)) continue;
            throw new ConstraintViolationException("Merging two custom operators is not allowed unless the values are equal.");
        }
        HashMap customOperators = new HashMap(superior.getCustomOperators());
        customOperators.putAll(subordinate.getCustomOperators());
        MetadataPolicy.Builder builder = new MetadataPolicy.Builder().withSubsetOfValues(MetadataPolicyHelper.doMergeForTwoLists(superior.getSubsetOfValues(), subordinate.getSubsetOfValues(), false)).withOneOfValues(MetadataPolicyHelper.doMergeForTwoLists(superior.getOneOfValues(), subordinate.getOneOfValues(), false)).withSupersetOfValues(MetadataPolicyHelper.doMergeForTwoLists(superior.getSupersetOfValues(), subordinate.getSupersetOfValues(), true)).withAdd(MetadataPolicyHelper.doMergeForTwoObjects(superior.getAdd(), subordinate.getAdd(), true)).withValue(value != null ? value : subordinate.getValue()).withDefaultValue(defaultValue != null ? defaultValue : subordinate.getDefaultValue()).withEssential(superior.isEssential() ? Boolean.TRUE : subordinate.getEssential()).withRegexp(regexp);
        for (String customOperator : customOperators.keySet()) {
            builder.withCustomOperator(customOperator, customOperators.get(customOperator));
        }
        return builder.build();
    }

    @Nullable
    private static Object doMergeForTwoObjects(@Nullable Object superior, @Nullable Object subordinate, boolean union) throws ConstraintViolationException {
        if (superior == null) {
            return subordinate;
        }
        if (superior instanceof List) {
            if (subordinate instanceof List) {
                return MetadataPolicyHelper.doMergeForTwoLists(new ArrayList((List)superior), (List)subordinate, union);
            }
            return MetadataPolicyHelper.doMergeForTwoLists(new ArrayList((List)superior), subordinate == null ? null : List.of(subordinate), union);
        }
        if (subordinate instanceof List) {
            return MetadataPolicyHelper.doMergeForTwoLists(List.of(superior), (List)subordinate, union);
        }
        if (subordinate == null) {
            return superior;
        }
        if (union) {
            if (superior.equals(subordinate)) {
                return superior;
            }
            return List.of(superior, subordinate);
        }
        if (!superior.equals(subordinate)) {
            throw new ConstraintViolationException("Merging of two different values is not allowed");
        }
        return superior;
    }

    @Nullable
    private static List<Object> doMergeForTwoLists(@Nullable List<?> superior, @Nullable List<?> subordinate, boolean union) {
        if (superior == null) {
            return subordinate;
        }
        if (subordinate == null) {
            return List.copyOf(superior);
        }
        if (union) {
            HashSet set = new HashSet(superior);
            set.addAll(subordinate);
            return List.copyOf(set);
        }
        ArrayList<Object> result = new ArrayList<Object>(superior);
        result.retainAll(subordinate);
        return result;
    }
}

