/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.CustomMetadataPolicyOperator;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;

public class DefaultMetadataPolicyOperator
extends AbstractInitializableComponent
implements CustomMetadataPolicyOperator {
    @NonnullAfterInit
    private Predicate<MetadataPolicy> validator;
    @NonnullAfterInit
    private BiFunction<Object, MetadataPolicy, Object> valueOperator;

    public void setValidator(@Nonnull Predicate<MetadataPolicy> predicate) {
        this.checkSetterPreconditions();
        this.validator = (Predicate)Constraint.isNotNull(predicate, (String)"The validator predicate cannot be null");
    }

    public void setValueOperator(@Nonnull BiFunction<Object, MetadataPolicy, Object> function) {
        this.checkSetterPreconditions();
        this.valueOperator = (BiFunction)Constraint.isNotNull(function, (String)"The value operator cannot be null");
    }

    public void doInitialize() throws ComponentInitializationException {
        if (this.validator == null) {
            throw new ComponentInitializationException("The validator predicate cannot be null");
        }
        if (this.valueOperator == null) {
            throw new ComponentInitializationException("The value operator cannot be null");
        }
    }

    @Override
    public boolean validate(@Nullable MetadataPolicy policy) {
        return this.validator.test(policy);
    }

    @Override
    public Object apply(@Nullable Object inputValue, @Nullable MetadataPolicy policy) throws ConstraintViolationException {
        return this.valueOperator.apply(inputValue, policy);
    }
}

