/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.oidc.metadata.criterion.ClientSecretReferenceCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractClientSecretValueResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ResolverServiceClientSecretValueResolver
extends AbstractClientSecretValueResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ResolverServiceClientSecretValueResolver.class);
    @NonnullAfterInit
    private ReloadableService<AttributeResolver> service;
    @Nonnull
    private List<String> attributeIds = CollectionSupport.emptyList();

    public void setAttributeResolver(@Nonnull ReloadableService<AttributeResolver> resolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.service = (ReloadableService)Constraint.isNotNull(resolver, (String)"Attribute resolver service can not be null");
    }

    @NonnullAfterInit
    public ReloadableService<AttributeResolver> getAttributeResolver() {
        return this.service;
    }

    public void setAttributeIds(@Nonnull List<String> ids) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.attributeIds = (List)Constraint.isNotEmpty(ids, (String)"The list of attribute ids cannot be empty");
    }

    @Nonnull
    public List<String> getAttributeIds() {
        return this.attributeIds;
    }

    @Nonnull
    public Iterable<String> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        EntityIdCriterion entityIdCrit;
        ClientSecretReferenceCriterion referenceCriterion;
        this.checkComponentActive();
        ClientSecretReferenceCriterion clientSecretReferenceCriterion = referenceCriterion = criteria != null ? (ClientSecretReferenceCriterion)criteria.get(ClientSecretReferenceCriterion.class) : null;
        if (referenceCriterion == null) {
            throw new ResolverException("The client secret reference criterion must be included in the criteria.");
        }
        ProfileRequestContext profileRequestContext = new ProfileRequestContext();
        AttributeResolutionContext resolutionContext = (AttributeResolutionContext)profileRequestContext.ensureSubcontext(AttributeResolutionContext.class);
        resolutionContext.setPrincipal(referenceCriterion.getSecretReference());
        resolutionContext.setResolutionLabel(((Object)((Object)this)).getClass().getSimpleName());
        EntityIdCriterion entityIdCriterion = entityIdCrit = criteria != null ? (EntityIdCriterion)criteria.get(EntityIdCriterion.class) : null;
        if (entityIdCrit != null) {
            resolutionContext.setAttributeRecipientID(entityIdCrit.getEntityId());
        }
        ReloadableService<AttributeResolver> localService = this.getAttributeResolver();
        assert (localService != null);
        resolutionContext.resolveAttributes(localService);
        Map resolvedAttributes = resolutionContext.getResolvedIdPAttributes();
        LazySet result = new LazySet();
        for (String attributeId : this.attributeIds) {
            if (!resolvedAttributes.containsKey(attributeId)) continue;
            for (IdPAttributeValue value : ((IdPAttribute)resolvedAttributes.get(attributeId)).getValues()) {
                if (!(value instanceof StringAttributeValue)) continue;
                this.log.debug("Found a value for reference '{}' via attribute ID {}", (Object)referenceCriterion.getSecretReference(), (Object)attributeId);
                result.add((Object)((StringAttributeValue)value).getValue());
            }
        }
        return result;
    }

    @Nullable
    public String resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<String> iterator = this.resolve(criteria).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    protected void doDestroy() {
        this.service = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getAttributeResolver() == null) {
            throw new ComponentInitializationException("Attribute resolver service can not be null");
        }
    }
}

