/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ProviderMetadataResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.slf4j.Logger;

public class ReloadingProviderMetadataProvider
extends AbstractIdentifiableInitializableComponent
implements ProviderMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadingProviderMetadataProvider.class);
    private final ReloadableService<ProviderMetadataResolver> service;

    public ReloadingProviderMetadataProvider(@Nonnull ReloadableService<ProviderMetadataResolver> resolverService) {
        this.service = (ReloadableService)Constraint.isNotNull(resolverService, (String)"ProviderMetadataResolver Service cannot be null");
    }

    @Nonnull
    public Iterable<OIDCProviderMetadata> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        block10: {
            Iterable iterable;
            block9: {
                this.ifNotInitializedThrowUninitializedComponentException();
                ServiceableComponent component = this.service.getServiceableComponent();
                try {
                    ProviderMetadataResolver resolver = (ProviderMetadataResolver)component.getComponent();
                    iterable = resolver.resolve((Object)criteria);
                    if (component == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (component != null) {
                            try {
                                component.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ResolverException e) {
                        this.log.error("ProviderMetadataResolver '{}': Error during resolution", (Object)this.getId(), (Object)e);
                        break block10;
                    }
                    catch (ServiceException e) {
                        this.log.error("ReloadingProviderMetadataProvider '{}': Error accessing underlying source: Invalid configuration.", (Object)this.getId());
                    }
                }
                component.close();
            }
            return iterable;
        }
        return CollectionSupport.emptySet();
    }

    @Nullable
    public OIDCProviderMetadata resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        block10: {
            OIDCProviderMetadata oIDCProviderMetadata;
            block9: {
                this.ifNotInitializedThrowUninitializedComponentException();
                ServiceableComponent component = this.service.getServiceableComponent();
                try {
                    ProviderMetadataResolver resolver = (ProviderMetadataResolver)component.getComponent();
                    oIDCProviderMetadata = (OIDCProviderMetadata)resolver.resolveSingle((Object)criteria);
                    if (component == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (component != null) {
                            try {
                                component.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ResolverException e) {
                        this.log.error("ProviderMetadataResolver '{}': Error during resolution", (Object)this.getId(), (Object)e);
                        break block10;
                    }
                    catch (ServiceException e) {
                        this.log.error("ReloadingProviderMetadataProvider '{}': Error accessing underlying source: Invalid configuration.", (Object)this.getId());
                    }
                }
                component.close();
            }
            return oIDCProviderMetadata;
        }
        return null;
    }
}

