/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.SoftwareID;
import com.nimbusds.oauth2.sdk.id.SoftwareVersion;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.saml.xmlobject.DefaultAcrValue;
import net.shibboleth.oidc.saml.xmlobject.MetadataValueSAMLObject;
import net.shibboleth.oidc.saml.xmlobject.OAuthRPExtensions;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.JWKReferenceCredential;
import net.shibboleth.oidc.security.credential.NimbusSecretCredential;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoProvider;
import org.slf4j.Logger;

public class ClientInformationNodeProcessor
implements MetadataNodeProcessor {
    @Nonnull
    public static final String BINDING_ID_REDIRECT_URI = "https://tools.ietf.org/html/rfc6749#section-3.1.2";
    @Nonnull
    public static final String BINDING_ID_FRONT_SLO_URI = "https://openid.net/specs/openid-connect-frontchannel-1_0.html";
    @Nonnull
    public static final String BINDING_ID_BACK_SLO_URI = "https://openid.net/specs/openid-connect-backchannel-1_0.html";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientInformationNodeProcessor.class);
    @Nonnull
    private final KeyInfoCredentialResolver keyInfoCredentialResolver;

    public ClientInformationNodeProcessor(@Nonnull List<KeyInfoProvider> keyInfoProviders) {
        this.keyInfoCredentialResolver = new BasicProviderKeyInfoCredentialResolver(keyInfoProviders);
    }

    public void process(@Nullable XMLObject metadataNode) throws FilterException {
        SPSSODescriptor roleDescriptor;
        if (metadataNode instanceof SPSSODescriptor && (roleDescriptor = (SPSSODescriptor)metadataNode).isSupportedProtocol("http://openid.net/specs/openid-connect-core-1_0.html")) {
            ClientID clientId = this.parseClientID(roleDescriptor);
            if (clientId == null || StringSupport.trimOrNull((String)clientId.getValue()) == null) {
                this.log.error("Could not find a value for client_id, nothing to do");
                return;
            }
            Iterable<Credential> credentials = this.resolveCredentials(roleDescriptor);
            String clientIdValue = clientId.getValue();
            assert (clientIdValue != null);
            OIDCClientMetadata metadata = this.populateMetadata(roleDescriptor, credentials, clientIdValue);
            Secret clientSecret = this.parseClientSecret(credentials);
            OIDCClientInformation clientInformation = new OIDCClientInformation(clientId, null, metadata, clientSecret);
            metadataNode.getObjectMetadata().put((Object)clientInformation);
        }
    }

    @Nullable
    protected ClientID parseClientID(@Nonnull SPSSODescriptor roleDescriptor) {
        if (!roleDescriptor.hasParent() || !(roleDescriptor.getParent() instanceof EntityDescriptor)) {
            this.log.warn("Unexpected structure, EntityDescriptor not as a parent for OAuthRPRoleDescriptor");
            return null;
        }
        EntityDescriptor entityDescriptor = (EntityDescriptor)roleDescriptor.getParent();
        assert (entityDescriptor != null);
        return new ClientID(entityDescriptor.getEntityID());
    }

    @Nullable
    protected Secret parseClientSecret(@Nonnull Iterable<Credential> credentials) {
        for (Credential credential : credentials) {
            this.log.trace("Processing credential type {}", (Object)credential.getCredentialType());
            if (!NimbusSecretCredential.class.isAssignableFrom(credential.getCredentialType())) continue;
            this.log.debug("Found client secret from the credentials");
            return ((NimbusSecretCredential)credential).getSecret();
        }
        this.log.trace("No client secret found from the credentials");
        return null;
    }

    @Nonnull
    protected OIDCClientMetadata populateMetadata(@Nonnull SPSSODescriptor roleDescriptor, @Nonnull Iterable<Credential> credentials, @Nonnull String clientId) {
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        OAuthRPExtensions extensions = this.getOAuthRPExtensions(roleDescriptor);
        if (extensions != null) {
            Set<URI> frontChannelLogoutUris;
            String softwareVersion;
            metadata.setApplicationType(this.parseApplicationType(extensions));
            metadata.setURI(this.getSingleURIValue(extensions.getClientUri()));
            metadata.setDefaultACRs(this.parseDefaultAcrValues(extensions));
            metadata.setGrantTypes(this.parseGrantTypes(extensions));
            metadata.setIDTokenJWEAlg(this.parseJweAlgorithm(extensions.getIdTokenEncryptedResponseAlg()));
            metadata.setIDTokenJWEEnc(this.parseEncryptionMethod(extensions.getIdTokenEncryptedResponseEnc()));
            metadata.setIDTokenJWSAlg(this.parseJwsAlgorithm(extensions.getIdTokenSignedResponseAlg()));
            metadata.setInitiateLoginURI(this.getSingleURIValue(extensions.getInitiateLoginUri()));
            metadata.setPostLogoutRedirectionURIs(this.parseUris(extensions.getPostLogoutRedirectUris()));
            metadata.setRedirectionURIs(this.parseRedirectUris(roleDescriptor));
            metadata.setRequestObjectJWEAlg(this.parseJweAlgorithm(extensions.getRequestObjectEncryptionAlg()));
            metadata.setRequestObjectJWEEnc(this.parseEncryptionMethod(extensions.getRequestObjectEncryptionEnc()));
            metadata.setRequestObjectJWSAlg(this.parseJwsAlgorithm(extensions.getRequestObjectSigningAlg()));
            metadata.setRequestObjectURIs(this.parseUris(extensions.getRequestUris()));
            metadata.setResponseTypes(this.parseResponseTypes(extensions));
            metadata.setScope(this.parseScopes(extensions));
            metadata.setSectorIDURI(this.getSingleURIValue(extensions.getSectorIdentifierUri()));
            String softwareId = extensions.getSoftwareId();
            if (softwareId != null) {
                metadata.setSoftwareID(new SoftwareID(softwareId));
            }
            if ((softwareVersion = extensions.getSoftwareVersion()) != null) {
                metadata.setSoftwareVersion(new SoftwareVersion(softwareVersion));
            }
            if (extensions.getDefaultMaxAge() > 0) {
                metadata.setDefaultMaxAge(extensions.getDefaultMaxAge());
            }
            metadata.requiresAuthTime(extensions.isRequireAuthTime());
            metadata.setSubjectType(this.parseSubjectType(roleDescriptor));
            metadata.setTokenEndpointAuthMethod(this.parseClientAuthenticationMethod(extensions));
            metadata.setTokenEndpointAuthJWSAlg(this.parseJwsAlgorithm(extensions.getTokenEndpointAuthSigningAlg()));
            metadata.setUserInfoJWEAlg(this.parseJweAlgorithm(extensions.getUserInfoEncryptedResponseAlg()));
            metadata.setUserInfoJWEEnc(this.parseEncryptionMethod(extensions.getUserInfoEncryptedResponseEnc()));
            metadata.setUserInfoJWSAlg(this.parseJwsAlgorithm(extensions.getUserInfoSignedResponseAlg()));
            metadata.setJWKSetURI(this.parseJwkUri(credentials, clientId));
            if (metadata.getJWKSetURI() == null) {
                metadata.setJWKSet(this.parseJwkSet(credentials, clientId));
            }
            metadata.setCustomField("audience", this.parseAudiences(extensions));
            Set<URI> backChannelLogoutUris = this.parseLogoutUris(roleDescriptor, BINDING_ID_BACK_SLO_URI);
            if (!backChannelLogoutUris.isEmpty()) {
                if (backChannelLogoutUris.size() > 1) {
                    this.log.warn("More than one back-channel logout URI defined, picking up only one.");
                }
                metadata.setBackChannelLogoutURI(backChannelLogoutUris.iterator().next());
                metadata.requiresBackChannelLogoutSession(extensions.isBackChannelLogoutSessionRequired());
            }
            if (!(frontChannelLogoutUris = this.parseLogoutUris(roleDescriptor, BINDING_ID_FRONT_SLO_URI)).isEmpty()) {
                if (frontChannelLogoutUris.size() > 1) {
                    this.log.warn("More than one front-channel logout URI defined, picking up only one.");
                }
                metadata.setFrontChannelLogoutURI(frontChannelLogoutUris.iterator().next());
                metadata.requiresFrontChannelLogoutSession(extensions.isFrontChannelLogoutSessionRequired());
            }
        } else {
            this.log.debug("No {} found to be processed", (Object)"OAuthRPExtensions");
        }
        return metadata;
    }

    @Nullable
    protected OAuthRPExtensions getOAuthRPExtensions(@Nonnull SPSSODescriptor roleDescriptor) {
        Extensions extensions = roleDescriptor.getExtensions();
        if (extensions == null) {
            this.log.debug("No extensions found from the given SPSSODescriptor");
            return null;
        }
        List rpExtensions = extensions.getUnknownXMLObjects(OAuthRPExtensions.TYPE_NAME);
        if (rpExtensions == null || rpExtensions.isEmpty()) {
            this.log.debug("SPSSODescriptor Extensions element had no {} child elements", (Object)"OAuthRPExtensions");
            return null;
        }
        if (rpExtensions.size() > 1) {
            this.log.warn("More than one {} defined, using only one of them", (Object)"OAuthRPExtensions");
        }
        if (rpExtensions.get(0) instanceof OAuthRPExtensions) {
            this.log.debug("Successfully parsed {}", (Object)"OAuthRPExtensions");
            return (OAuthRPExtensions)rpExtensions.get(0);
        }
        this.log.warn("Could not parse {} from the element", (Object)"OAuthRPExtensions");
        return null;
    }

    @Nonnull
    protected Iterable<Credential> resolveCredentials(final @Nonnull SPSSODescriptor roleDescriptor) {
        MetadataCredentialResolver credentialResolver = new MetadataCredentialResolver();
        credentialResolver.setKeyInfoCredentialResolver(this.keyInfoCredentialResolver);
        credentialResolver.setRoleDescriptorResolver((RoleDescriptorResolver)new SkeletonEchoingRoleDescriptorResolver(){

            @Nullable
            public RoleDescriptor resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
                return roleDescriptor;
            }
        });
        RoleDescriptorCriterion criterion = new RoleDescriptorCriterion((RoleDescriptor)roleDescriptor);
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)criterion);
        try {
            credentialResolver.initialize();
        }
        catch (ComponentInitializationException e) {
            this.log.error("Could not initialize the SAML metadata credential resolver, cannot resolve JWKSet", (Throwable)e);
        }
        try {
            return credentialResolver.resolve(criteriaSet);
        }
        catch (ResolverException e) {
            this.log.warn("Could not resolve credentials", (Throwable)e);
            return CollectionSupport.emptySet();
        }
    }

    @Nullable
    protected JWKSet parseJwkSet(@Nonnull Iterable<Credential> credentials, @Nonnull String clientId) {
        ArrayList<JWK> jwks = new ArrayList<JWK>();
        for (Credential credential : credentials) {
            JWK jwk = CredentialConversionUtil.credentialToKey((Credential)credential);
            if (jwk == null) {
                this.log.debug("Could not parse credential of {} to a JWK", (Object)clientId);
                continue;
            }
            this.log.trace("Successfully parsed a JWK to client {}: {}", (Object)clientId, (Object)jwk.toJSONString());
            jwks.add(jwk);
        }
        return jwks.isEmpty() ? null : new JWKSet(jwks);
    }

    @Nullable
    protected URI parseJwkUri(@Nonnull Iterable<Credential> credentials, @Nonnull String clientId) {
        for (Credential credential : credentials) {
            if (!(credential instanceof JWKReferenceCredential)) continue;
            this.log.trace("Successfully located a JWKS URI for client {}: {}", (Object)clientId, (Object)((JWKReferenceCredential)credential).getReferenceURI());
            return ((JWKReferenceCredential)credential).getReferenceURI();
        }
        return null;
    }

    @Nullable
    protected ClientAuthenticationMethod parseClientAuthenticationMethod(@Nonnull OAuthRPExtensions extensions) {
        String metadataValue = StringSupport.trimOrNull((String)extensions.getTokenEndpointAuthMethod());
        if (metadataValue == null) {
            return null;
        }
        return ClientAuthenticationMethod.parse((String)metadataValue);
    }

    @Nonnull
    protected ApplicationType parseApplicationType(@Nonnull OAuthRPExtensions extensions) {
        String metadataValue = StringSupport.trimOrNull((String)extensions.getApplicationType());
        if (ApplicationType.NATIVE.toString().equalsIgnoreCase(metadataValue)) {
            return ApplicationType.NATIVE;
        }
        return ApplicationType.WEB;
    }

    @Nonnull
    protected SubjectType parseSubjectType(@Nonnull SPSSODescriptor roleDescriptor) {
        List nameIdFormats = roleDescriptor.getNameIDFormats();
        if (nameIdFormats == null || nameIdFormats.isEmpty()) {
            this.log.warn("No NameIDFormat defined, using 'public'");
            return SubjectType.PUBLIC;
        }
        if (nameIdFormats.size() > 1) {
            this.log.warn("Multiple NameIDFormats defined, using first one with a known value");
        }
        for (NameIDFormat format : nameIdFormats) {
            if (format == null) continue;
            if ("urn:mace:shibboleth:metadata:oidc:1.0:nameid-format:public".equals(format.getURI())) {
                return SubjectType.PUBLIC;
            }
            if (!"urn:mace:shibboleth:metadata:oidc:1.0:nameid-format:pairwise".equals(format.getURI())) continue;
            return SubjectType.PAIRWISE;
        }
        this.log.warn("No known NameIDFormats defined, using 'public'");
        return SubjectType.PUBLIC;
    }

    @Nonnull
    protected List<ACR> parseDefaultAcrValues(@Nonnull OAuthRPExtensions extensions) {
        ArrayList<ACR> acrs = new ArrayList<ACR>();
        for (DefaultAcrValue acr : extensions.getDefaultAcrValues()) {
            String value = StringSupport.trimOrNull((String)acr.getValue());
            if (value == null) continue;
            acrs.add(new ACR(value));
        }
        return acrs;
    }

    @Nonnull
    protected Set<GrantType> parseGrantTypes(@Nonnull OAuthRPExtensions extensions) {
        HashSet<GrantType> grantTypes = new HashSet<GrantType>();
        Collection<String> values = this.getListValues(extensions.getGrantTypes());
        for (String value : values) {
            grantTypes.add(new GrantType(value));
        }
        return grantTypes;
    }

    @Nonnull
    protected Set<ResponseType> parseResponseTypes(@Nonnull OAuthRPExtensions extensions) {
        HashSet<ResponseType> responseTypes = new HashSet<ResponseType>();
        Collection<String> values = this.getListValues(extensions.getResponseTypes());
        for (String value : values) {
            responseTypes.add(new ResponseType(value.split("\\+")));
        }
        return responseTypes;
    }

    @Nonnull
    protected Scope parseScopes(@Nonnull OAuthRPExtensions extensions) {
        Scope scope = new Scope();
        Collection<String> values = this.getListValues(extensions.getScopes());
        for (String value : values) {
            scope.add(value);
        }
        return scope;
    }

    @Nullable
    protected JWEAlgorithm parseJweAlgorithm(@Nullable String value) {
        if (value != null) {
            return new JWEAlgorithm(value);
        }
        return null;
    }

    @Nullable
    protected JWSAlgorithm parseJwsAlgorithm(@Nullable String value) {
        if (value != null) {
            return new JWSAlgorithm(value);
        }
        return null;
    }

    @Nullable
    protected EncryptionMethod parseEncryptionMethod(@Nullable String value) {
        if (value != null) {
            return new EncryptionMethod(value);
        }
        return null;
    }

    @Nonnull
    protected Set<URI> parseRedirectUris(@Nonnull SPSSODescriptor roleDescriptor) {
        HashSet<URI> uris = new HashSet<URI>();
        for (AssertionConsumerService acs : roleDescriptor.getAssertionConsumerServices()) {
            URI uri;
            if (!BINDING_ID_REDIRECT_URI.equals(acs.getBinding()) || (uri = this.getSingleURIValue(acs.getLocation())) == null) continue;
            uris.add(uri);
        }
        return uris;
    }

    @Nonnull
    protected Set<URI> parseUris(@Nonnull List<? extends MetadataValueSAMLObject> listOfValues) {
        HashSet<URI> uris = new HashSet<URI>();
        for (MetadataValueSAMLObject metadataValueSAMLObject : listOfValues) {
            URI uri;
            if (metadataValueSAMLObject == null || (uri = this.getSingleURIValue(metadataValueSAMLObject)) == null) continue;
            uris.add(uri);
        }
        return uris;
    }

    @Nullable
    @NonnullElements
    protected List<String> parseAudiences(@Nonnull OAuthRPExtensions extensions) {
        ArrayList<String> auds = new ArrayList<String>();
        for (XMLObject aud : extensions.getUnknownXMLObjects(Audience.DEFAULT_ELEMENT_NAME)) {
            if (!(aud instanceof Audience) || ((Audience)aud).getURI() == null) continue;
            auds.add(((Audience)aud).getURI());
        }
        return auds.isEmpty() ? null : auds;
    }

    @Nonnull
    protected Set<URI> parseLogoutUris(@Nonnull SPSSODescriptor roleDescriptor, @Nonnull String binding) {
        HashSet<URI> uris = new HashSet<URI>();
        for (SingleLogoutService slo : roleDescriptor.getSingleLogoutServices()) {
            URI uri;
            if (!binding.equals(slo.getBinding()) || (uri = this.getSingleURIValue(slo.getLocation())) == null) continue;
            uris.add(uri);
        }
        return uris;
    }

    @Nonnull
    @NonnullElements
    protected Collection<String> getListValues(@Nullable String metadataValue) {
        if (metadataValue != null) {
            return StringSupport.stringToList((String)metadataValue, (String)" \t\n\r");
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    protected URI getSingleURIValue(@Nonnull MetadataValueSAMLObject metadataValue) {
        return this.getSingleURIValue(metadataValue.getValue());
    }

    @Nullable
    protected URI getSingleURIValue(@Nullable String value) {
        if (value != null) {
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                this.log.warn("Could not parse {} into an URI", (Object)value, (Object)e);
            }
        }
        return null;
    }

    protected abstract class SkeletonEchoingRoleDescriptorResolver
    implements RoleDescriptorResolver {
        protected SkeletonEchoingRoleDescriptorResolver() {
        }

        @Nonnull
        public Iterable<RoleDescriptor> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
            RoleDescriptor role = (RoleDescriptor)this.resolveSingle(criteria);
            return role != null ? CollectionSupport.singletonList((Object)role) : CollectionSupport.emptyList();
        }

        public String getId() {
            return "EmbeddedLocalRoleDescriptorResolver";
        }

        public boolean isRequireValidMetadata() {
            return false;
        }

        public void setRequireValidMetadata(boolean requireValidMetadata) {
        }
    }
}

