/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ProviderMetadataResolver;
import net.shibboleth.oidc.metadata.RefreshableProviderMetadataResolver;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.slf4j.Logger;

public class ChainingProviderMetadataResolver
extends AbstractIdentifiableInitializableComponent
implements RefreshableProviderMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingProviderMetadataResolver.class);
    @Nonnull
    @NonnullElements
    private List<ProviderMetadataResolver> resolvers = CollectionSupport.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<ProviderMetadataResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(@Nullable @NonnullElements List<? extends ProviderMetadataResolver> newResolvers) throws ResolverException {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.resolvers = newResolvers == null || newResolvers.isEmpty() ? CollectionSupport.emptyList() : CollectionSupport.copyToList(newResolvers);
    }

    @Nullable
    public OIDCProviderMetadata resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<OIDCProviderMetadata> iterator;
        this.ifNotInitializedThrowUninitializedComponentException();
        Iterable<OIDCProviderMetadata> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Nonnull
    public Iterable<OIDCProviderMetadata> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        this.ifNotInitializedThrowUninitializedComponentException();
        for (ProviderMetadataResolver resolver : this.resolvers) {
            try {
                Iterable providerMetadatas = resolver.resolve((Object)criteria);
                if (providerMetadatas == null || !providerMetadatas.iterator().hasNext()) continue;
                return providerMetadatas;
            }
            catch (ResolverException e) {
                this.log.warn("Error retrieving provider metadata from resolver of type {}, proceeding to next resolver", (Object)resolver.getClass().getName(), (Object)e);
            }
        }
        return CollectionSupport.emptyList();
    }

    public void refresh() throws ResolverException {
        for (ProviderMetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableProviderMetadataResolver)) continue;
            ((RefreshableProviderMetadataResolver)resolver).refresh();
        }
    }

    @Nullable
    public Instant getLastUpdate() {
        Instant ret = null;
        for (ProviderMetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableProviderMetadataResolver)) continue;
            Instant lastUpdate = ((RefreshableProviderMetadataResolver)resolver).getLastUpdate();
            if (ret != null && !ret.isBefore(lastUpdate)) continue;
            ret = lastUpdate;
        }
        return ret;
    }

    @Nullable
    public Instant getLastRefresh() {
        Instant ret = null;
        for (ProviderMetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableProviderMetadataResolver)) continue;
            Instant lastRefresh = ((RefreshableProviderMetadataResolver)resolver).getLastRefresh();
            if (ret != null && !ret.isBefore(lastRefresh)) continue;
            ret = lastRefresh;
        }
        return ret;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        ArrayList<CallSite> resolverDetails = new ArrayList<CallSite>();
        for (ProviderMetadataResolver resolver : this.resolvers) {
            resolverDetails.add((CallSite)((Object)(resolver.getId() + ": " + this.countClients(resolver) + " clients")));
        }
        this.log.info("ChainingProviderMetadataResolver was configured with the following resolvers: {}", resolverDetails);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.resolvers = CollectionSupport.emptyList();
    }

    protected int countClients(ProviderMetadataResolver resolver) {
        Iterable iterable;
        int count = 0;
        try {
            iterable = resolver.resolve((Object)new CriteriaSet());
        }
        catch (ResolverException e) {
            this.log.warn("ChainingProviderMetadataResolver could not count clients for {}", (Object)resolver.getId());
            return 0;
        }
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }
}

