/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.DynamicMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.DynamicMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.FetchThroughMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.FetchThroughMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.impl.DefaultBatchBackingStore;
import net.shibboleth.oidc.metadata.impl.DefaultDynamicBackingStore;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public final class MetadataCacheBuilder {
    private MetadataCacheBuilder() {
    }

    public static class Builder<IdentifierType, MetadataType> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(MetadataCacheBuilder.class);

        @Nonnull
        public MetadataCache<MetadataType> build(@Nonnull MetadataCacheBuilderSpec<IdentifierType, MetadataType> specification) throws ComponentInitializationException {
            if (specification instanceof BatchMetadataCacheBuilderSpec) {
                BatchMetadataCacheBuilderSpec spec = (BatchMetadataCacheBuilderSpec)specification;
                BatchMetadataCache cache = new BatchMetadataCache(new DefaultBatchBackingStore());
                cache.setSourceMetadataExpiryStrategy((Function)Constraint.isNotNull(spec.getSourceMetadataExpiryStrategy(), (String)"Metadata expiry strategy can not be null"));
                cache.setLoadingStrategy((LoadingStrategy)Constraint.isNotNull((Object)spec.getLoadingStrategy(), (String)"Loading strategy can not be null"));
                cache.setParsingStrategy((Function)Constraint.isNotNull(spec.getParsingStrategy(), (String)"Parsing strategy can not be null"));
                cache.setMinRefreshDelay(spec.getMinRefreshDelay());
                cache.setMaxRefreshDelay(spec.getMaxRefreshDelay());
                cache.setRefreshDelayFactor(spec.getRefreshDelayFactor());
                cache.setIdentifierExtractionStrategy((Function)Constraint.isNotNull(spec.getIdentifierExtractionStrategy(), (String)"Identifier extraction strategy can not be null"));
                cache.setCriteriaToIdentifierStrategy((Function)Constraint.isNotNull(spec.getCriteriaToIdentifierStrategy(), (String)"Criteria to identifier strategy can not be null"));
                cache.setMetadataFilterStrategy(spec.getMetadataFilterStrategy());
                cache.setMetadataBeforeRemovalHook(spec.getMetadataBeforeRemovalHook());
                cache.setMatchOnIdentifierRequired(spec.isMatchOnIdentifierRequired());
                cache.setMetadataValidPredicate(spec.getMetadataValidPredicate());
                cache.setSourceMetadataValidPredicate(spec.getSourceMetadataValidPredicate());
                cache.setId(spec.getCacheId());
                cache.initialize();
                return cache;
            }
            if (specification instanceof DynamicMetadataCacheBuilderSpec) {
                DynamicMetadataCacheBuilderSpec spec = (DynamicMetadataCacheBuilderSpec)specification;
                DynamicMetadataCache cache = new DynamicMetadataCache(new DefaultDynamicBackingStore());
                cache.setFetchStrategy((Function)Constraint.isNotNull(spec.getFetchStrategy(), (String)"Fetch strategy can not be null"));
                cache.setMinCacheDuration(spec.getMinCacheDuration());
                cache.setMaxCacheDuration(spec.getMaxCacheDuration());
                cache.setRefreshDelayFactor(spec.getRefreshDelayFactor());
                cache.setMaxIdleEntityData(spec.getMaxIdleEntityData());
                cache.setMetadataExpirationTimeStrategy((Function)Constraint.isNotNull(spec.getMetadataExpirationTimeStrategy(), (String)"Metadata expiry strategy can not be null"));
                cache.setIdentifierExtractionStrategy((Function)Constraint.isNotNull(spec.getIdentifierExtractionStrategy(), (String)"Identifier extraction strategy can not be null"));
                cache.setCriteriaToIdentifierStrategy((Function)Constraint.isNotNull(spec.getCriteriaToIdentifierStrategy(), (String)"Criteria to identifier strategy can not be null"));
                cache.setCleanupTaskInterval(spec.getCleanupTaskInterval());
                cache.setRemoveIdleEntityData(spec.isRemoveIdleEntityData());
                cache.setInitialCleanupTaskDelay(spec.getInitialCleanupTaskDelay());
                cache.setMetadataFilterStrategy(spec.getMetadataFilterStrategy());
                cache.setMetadataBeforeRemovalHook(spec.getMetadataBeforeRemovalHook());
                cache.setMetadataValidPredicate(spec.getMetadataValidPredicate());
                cache.setId(spec.getCacheId());
                cache.initialize();
                return cache;
            }
            if (specification instanceof FetchThroughMetadataCacheBuilderSpec) {
                FetchThroughMetadataCacheBuilderSpec spec = (FetchThroughMetadataCacheBuilderSpec)specification;
                FetchThroughMetadataCache cache = new FetchThroughMetadataCache();
                cache.setFetchStrategy((Function)Constraint.isNotNull(spec.getFetchStrategy(), (String)"Fetch strategy can not be null"));
                cache.setRefreshDelayFactor(spec.getRefreshDelayFactor());
                cache.setIdentifierExtractionStrategy((Function)Constraint.isNotNull(spec.getIdentifierExtractionStrategy(), (String)"Identifier extraction strategy can not be null"));
                cache.setCriteriaToIdentifierStrategy((Function)Constraint.isNotNull(spec.getCriteriaToIdentifierStrategy(), (String)"Criteria to identifier strategy can not be null"));
                cache.setMetadataFilterStrategy(spec.getMetadataFilterStrategy());
                cache.setMetadataBeforeRemovalHook(spec.getMetadataBeforeRemovalHook());
                cache.setMetadataValidPredicate(spec.getMetadataValidPredicate());
                cache.setId(spec.getCacheId());
                cache.initialize();
                return cache;
            }
            this.log.error("Unable to construct metadata cache, unknown specification type '{}'", (Object)specification.getClass().getSimpleName());
            throw new ComponentInitializationException("Cache Specification type not recognized");
        }
    }
}

