/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.io.IOException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.CacheLoadingException;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

@ThreadSafe
public class DefaultResourceLoadingStrategy
implements LoadingStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultResourceLoadingStrategy.class);
    @Nullable
    private final Resource metadataResource;
    @Nonnull
    @NotEmpty
    private final String metadataResourceFriendlyName;

    public DefaultResourceLoadingStrategy(@Nullable Resource metadata) {
        if (metadata == null) {
            this.log.warn("Resource is null, no bytes will be returned");
            this.metadataResource = null;
            this.metadataResourceFriendlyName = "No resource specified";
        } else {
            this.metadataResource = metadata;
            this.metadataResourceFriendlyName = metadata.getDescription();
        }
    }

    @Nullable
    private Instant getMetadataUpdateTime() throws IOException {
        return this.metadataResource != null ? Instant.ofEpochMilli(this.metadataResource.lastModified()) : null;
    }

    @Nullable
    public byte[] load(@Nonnull CacheLoadingContext context) throws CacheLoadingException {
        if (this.metadataResource == null) {
            return null;
        }
        try {
            Instant metadataUpdateTime = this.getMetadataUpdateTime();
            if (context.getLastRefresh() == null || context.getLastUpdate() == null || metadataUpdateTime == null || metadataUpdateTime.isAfter(context.getLastRefresh())) {
                assert (this.metadataResource != null);
                return this.metadataResource.getContentAsByteArray();
            }
            return null;
        }
        catch (Exception e) {
            String errMsg = "Unable to read metadata resource " + String.valueOf(this.metadataResource);
            this.log.error(errMsg, (Object)e.getMessage());
            throw new CacheLoadingException(errMsg, e);
        }
    }

    @Nonnull
    public String getSourceIdentifier() {
        return this.metadataResourceFriendlyName;
    }
}

