/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.validate.x509.AbstractX509Validator;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class X509RSAExponentValidator
extends AbstractX509Validator {
    @Nonnull
    @GuardedBy(value="this")
    private BigInteger errorBoundary = X509RSAExponentValidator.bigInteger(5L);
    @Nonnull
    @GuardedBy(value="this")
    private BigInteger warningBoundary = X509RSAExponentValidator.bigInteger(0L);

    @Nonnull
    private static final BigInteger bigInteger(long value) {
        BigInteger bi = BigInteger.valueOf(value);
        assert (bi != null);
        return bi;
    }

    public final synchronized BigInteger getErrorBoundary() {
        return this.errorBoundary;
    }

    public synchronized void setErrorBoundary(@Nonnull BigInteger length) {
        Constraint.isGreaterThanOrEqual((int)0, (int)length.compareTo(X509RSAExponentValidator.bigInteger(0L)), (String)"boundary value must not be negative");
        this.errorBoundary = length;
    }

    public void setErrorBoundary(long length) {
        this.setErrorBoundary(X509RSAExponentValidator.bigInteger(length));
    }

    public final synchronized BigInteger getWarningBoundary() {
        return this.warningBoundary;
    }

    public synchronized void setWarningBoundary(@Nonnull BigInteger length) {
        Constraint.isGreaterThanOrEqual((int)0, (int)length.compareTo(BigInteger.ZERO), (String)"boundary value must not be negative");
        this.warningBoundary = length;
    }

    public synchronized void setWarningBoundary(long length) {
        this.setWarningBoundary(X509RSAExponentValidator.bigInteger(length));
    }

    @Override
    public void doValidate(@Nonnull X509Certificate cert, @Nonnull Item<?> item, @Nonnull String callerId) {
        PublicKey key = cert.getPublicKey();
        if ("RSA".equals(key.getAlgorithm())) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            BigInteger exponent = rsaKey.getPublicExponent();
            if (!exponent.testBit(0)) {
                this.addError("RSA public exponent of " + String.valueOf(exponent) + " must be odd", item, callerId);
            } else if (exponent.compareTo(this.getErrorBoundary()) < 0) {
                this.addError("RSA public exponent of " + String.valueOf(exponent) + " is less than required " + String.valueOf(this.getErrorBoundary()), item, callerId);
            } else if (exponent.compareTo(this.getWarningBoundary()) < 0) {
                this.addWarning("RSA public exponent of " + String.valueOf(exponent) + " is less than recommended " + String.valueOf(this.getWarningBoundary()), item, callerId);
            }
        }
    }
}

