/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.url;

import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.validate.BaseValidator;
import net.shibboleth.metadata.validate.Validator;

public class HTTPSProtocolURLValidator
extends BaseValidator
implements Validator<URL> {
    public HTTPSProtocolURLValidator() {
        super("protocol '%s' must be https");
    }

    @Override
    @Nonnull
    public Validator.Action validate(@Nonnull URL url, @Nonnull Item<?> item, @Nonnull String callerId, @Nullable String valueContext) throws StageProcessingException {
        String protocol = url.getProtocol();
        assert (protocol != null);
        if (!"https".equals(protocol)) {
            this.addErrorMessage((Object)protocol, item, callerId, valueContext);
            return Validator.Action.DONE;
        }
        return Validator.Action.CONTINUE;
    }
}

