/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.element;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.validate.Validator;
import net.shibboleth.metadata.validate.element.BaseElementValidator;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class RejectMixedContentTextValidator
extends BaseElementValidator
implements Validator<Element> {
    public RejectMixedContentTextValidator() {
        super("element contains non-whitespace text content '%s'");
    }

    @Override
    @Nonnull
    public Validator.Action validate(@Nonnull Element e, @Nonnull Item<?> item, @Nonnull String callerId) {
        String content = ElementSupport.getElementContentAsString((Element)e).trim();
        if (!content.isEmpty()) {
            this.addErrorMessage((Object)content, item, callerId, e.getLocalName());
            return Validator.Action.DONE;
        }
        return Validator.Action.CONTINUE;
    }
}

