/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public abstract class BaseValidator
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    @GuardedBy(value="this")
    private String message;

    protected BaseValidator() {
        this.message = "value rejected: '%s'";
    }

    protected BaseValidator(@Nonnull String message) {
        this.message = message;
    }

    @Nonnull
    public final synchronized String getMessage() {
        return this.message;
    }

    public final synchronized void setMessage(@Nonnull String newMessage) {
        this.checkSetterPreconditions();
        this.message = (String)Constraint.isNotNull((Object)newMessage, (String)"message format string may not be null");
    }

    @Nonnull
    protected String makeComponentId(@Nonnull String callerId) {
        return callerId + "/" + this.ensureId();
    }

    protected void addError(@Nonnull String mess, @Nonnull Item<?> item, @Nonnull String callerId) {
        item.getItemMetadata().put((Object)new ErrorStatus(this.makeComponentId(callerId), mess));
    }

    protected void addWarning(@Nonnull String mess, @Nonnull Item<?> item, @Nonnull String callerId) {
        item.getItemMetadata().put((Object)new WarningStatus(this.makeComponentId(callerId), mess));
    }

    protected void addStatus(boolean error, @Nonnull String mess, @Nonnull Item<?> item, @Nonnull String callerId) {
        if (error) {
            this.addError(mess, item, callerId);
        } else {
            this.addWarning(mess, item, callerId);
        }
    }

    @Nonnull
    protected String formatValueContext(@Nullable String valueContext) {
        if (valueContext == null) {
            return "";
        }
        return "'" + valueContext + "': ";
    }

    @Nonnull
    private String formatMessage(@Nonnull Object subject) {
        String mess = String.format(this.getMessage(), subject);
        assert (mess != null);
        return mess;
    }

    @Nonnull
    private String formatMessage(@Nonnull Object subject, @Nonnull Throwable cause) {
        String cmsg = cause.getMessage();
        if (cmsg == null) {
            return this.formatMessage(subject);
        }
        return this.formatMessage(subject) + " (" + cmsg + ")";
    }

    protected void addErrorMessage(@Nonnull Object extra, @Nonnull Item<?> item, @Nonnull String callerId, @Nullable String valueContext) {
        this.addError(this.formatValueContext(valueContext) + this.formatMessage(extra), item, callerId);
    }

    protected void addErrorMessage(@Nonnull Object extra, @Nonnull Item<?> item, @Nonnull String callerId) {
        this.addError(this.formatMessage(extra), item, callerId);
    }

    protected void addErrorMessage(@Nonnull Object extra, @Nonnull Item<?> item, @Nonnull String callerId, @Nonnull Throwable cause) {
        this.addError(this.formatMessage(extra, cause), item, callerId);
    }
}

