/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.SimpleCollectionMergeStrategy;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.pipeline.impl.DirectExecutor;
import net.shibboleth.metadata.pipeline.impl.FutureSupport;
import net.shibboleth.metadata.pipeline.impl.PipelineCallable;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class PipelineMergeStage<T>
extends AbstractStage<T> {
    @Nonnull
    @GuardedBy(value="this")
    private Executor executor = new DirectExecutor();
    @Nonnull
    @GuardedBy(value="this")
    private Supplier<List<Item<T>>> collectionFactory = new SimpleItemCollectionFactory();
    @Nonnull
    @GuardedBy(value="this")
    private CollectionMergeStrategy mergeStrategy = new SimpleCollectionMergeStrategy();
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<Pipeline<T>> mergedPipelines = CollectionSupport.emptyList();

    @Nonnull
    public final synchronized Executor getExecutor() {
        return this.executor;
    }

    public synchronized void setExecutor(@Nonnull Executor exec) {
        this.checkSetterPreconditions();
        this.executor = (Executor)Constraint.isNotNull((Object)exec, (String)"executor can not be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<Pipeline<T>> getMergedPipelines() {
        return this.mergedPipelines;
    }

    public synchronized void setMergedPipelines(@Nonnull @NonnullElements @Unmodifiable List<? extends Pipeline<T>> pipelines) {
        this.checkSetterPreconditions();
        this.mergedPipelines = CollectionSupport.copyToList(pipelines);
    }

    @Nonnull
    public final synchronized Supplier<List<Item<T>>> getCollectionFactory() {
        return this.collectionFactory;
    }

    public synchronized void setCollectionFactory(@Nonnull Supplier<List<Item<T>>> factory) {
        this.checkSetterPreconditions();
        this.collectionFactory = (Supplier)Constraint.isNotNull(factory, (String)"Collection factory may not be null");
    }

    @Nonnull
    public final synchronized CollectionMergeStrategy getCollectionMergeStrategy() {
        return this.mergeStrategy;
    }

    public synchronized void setCollectionMergeStrategy(@Nonnull CollectionMergeStrategy strategy) {
        this.checkSetterPreconditions();
        this.mergeStrategy = strategy;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items) throws StageProcessingException {
        ArrayList<FutureTask<T>> pipelineResultFutures = new ArrayList<FutureTask<T>>();
        for (Pipeline<T> pipeline : this.getMergedPipelines()) {
            assert (pipeline != null);
            List<Item<T>> list = this.getCollectionFactory().get();
            assert (list != null);
            PipelineCallable<T> callable = new PipelineCallable<T>(pipeline, list);
            FutureTask<T> future = new FutureTask<T>(callable);
            this.getExecutor().execute(future);
            pipelineResultFutures.add(future);
        }
        ArrayList pipelineResults = new ArrayList();
        for (Future future : pipelineResultFutures) {
            assert (future != null);
            pipelineResults.add(FutureSupport.futureItems(future));
        }
        this.getCollectionMergeStrategy().merge(items, pipelineResults);
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        for (Pipeline<T> pipeline : this.mergedPipelines) {
            if (pipeline.isInitialized()) continue;
            pipeline.initialize();
        }
    }
}

