/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.FirstItemIdItemIdentificationStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemIdentificationStrategy;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.ClassToInstanceMultiMap;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public abstract class AbstractItemMetadataSelectionStage<T, B>
extends AbstractStage<T> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<Class<? extends B>> selectionRequirements = CollectionSupport.emptySet();
    @Nonnull
    @GuardedBy(value="this")
    private ItemIdentificationStrategy<T> identificationStrategy = new FirstItemIdItemIdentificationStrategy();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<Class<? extends B>> getSelectionRequirements() {
        return this.selectionRequirements;
    }

    public synchronized void setSelectionRequirements(@Nonnull @NonnullElements @Unmodifiable Collection<Class<? extends B>> requirements) {
        this.checkSetterPreconditions();
        this.selectionRequirements = CollectionSupport.copyToSet(requirements);
    }

    @Nonnull
    public final synchronized ItemIdentificationStrategy<T> getItemIdentificationStrategy() {
        return this.identificationStrategy;
    }

    public synchronized void setIdentificationStrategy(@Nonnull ItemIdentificationStrategy<T> strategy) {
        this.checkSetterPreconditions();
        this.identificationStrategy = (ItemIdentificationStrategy)Constraint.isNotNull(strategy, (String)"Item identification strategy can not be null");
    }

    @Override
    protected void doExecute(@Nonnull List<Item<T>> items) throws StageProcessingException {
        ArrayList<Item<T>> collectionCopy = new ArrayList<Item<T>>(items);
        for (Item<T> item : collectionCopy) {
            assert (item != null);
            ClassToInstanceMultiMap matchingMetadata = new ClassToInstanceMultiMap();
            for (Class<B> infoClass : this.getSelectionRequirements()) {
                if (!item.getItemMetadata().containsKey(infoClass)) continue;
                matchingMetadata.putAll((Iterable)item.getItemMetadata().get(infoClass));
            }
            if (matchingMetadata.isEmpty()) continue;
            this.doExecute(items, item, matchingMetadata);
        }
    }

    protected abstract void doExecute(@Nonnull @NonnullElements List<Item<T>> var1, @Nonnull Item<T> var2, @Nonnull @NonnullElements ClassToInstanceMultiMap<B> var3) throws StageProcessingException;
}

