/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.AttributeSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class SetCacheDurationStage
extends AbstractIteratingStage<Element> {
    @NonnullAfterInit
    @GuardedBy(value="this")
    private Duration cacheDuration;

    @NonnullAfterInit
    public final synchronized Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public synchronized void setCacheDuration(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)duration, (String)"cache duration cannot be null");
        Constraint.isFalse((boolean)duration.isZero(), (String)"cache duration cannot be zero");
        Constraint.isFalse((boolean)duration.isNegative(), (String)"cache duration cannot be negative");
        this.cacheDuration = duration;
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        if (SAMLMetadataSupport.isEntityOrEntitiesDescriptor(descriptor)) {
            Duration dur = this.getCacheDuration();
            assert (dur != null);
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
            AttributeSupport.appendDurationAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (Duration)dur);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.cacheDuration == null) {
            throw new ComponentInitializationException("cache duration must be set");
        }
    }
}

