/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntitiesDescriptorDisassemblerStage
extends AbstractStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(EntitiesDescriptorDisassemblerStage.class);

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<Element>> items) {
        ArrayList<Item<Element>> newItems = new ArrayList<Item<Element>>(items);
        items.clear();
        for (Item<Element> item : newItems) {
            Element element = item.unwrap();
            if (SAMLMetadataSupport.isEntitiesDescriptor(element)) {
                this.processEntitiesDescriptor(items, element);
                continue;
            }
            if (SAMLMetadataSupport.isEntityDescriptor(element)) {
                this.processEntityDescriptor(items, element);
                continue;
            }
            LOG.debug("{} pipeline stage: DOM Element {} not supported, ignoring it", (Object)this.getId(), (Object)QNameSupport.getNodeQName((Node)element));
        }
    }

    protected void processEntitiesDescriptor(@Nonnull @NonnullElements List<Item<Element>> items, @Nonnull Element entitiesDescriptor) {
        List children = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element child : children) {
            assert (child != null);
            if (SAMLMetadataSupport.isEntitiesDescriptor(child)) {
                this.processEntitiesDescriptor(items, child);
            }
            if (!SAMLMetadataSupport.isEntityDescriptor(child)) continue;
            this.processEntityDescriptor(items, child);
        }
    }

    protected void processEntityDescriptor(@Nonnull @NonnullElements List<Item<Element>> items, @Nonnull Element entityDescriptor) {
        DOMElementItem item = new DOMElementItem(entityDescriptor);
        items.add(item);
    }
}

