/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.HashSet;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DuplicateEntityInAggregateCheckingStage
extends AbstractIteratingStage<Element> {
    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element element = item.unwrap();
        NodeList eList = element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:metadata", SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME.getLocalPart());
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> reported = new HashSet<String>();
        int count = eList.getLength();
        for (int eIndex = 0; eIndex < count; ++eIndex) {
            Element entity = (Element)eList.item(eIndex);
            assert (entity != null);
            String id = SAMLMetadataSupport.getEntityID(entity);
            if (id == null) continue;
            if (ids.contains(id)) {
                if (reported.contains(id)) continue;
                item.getItemMetadata().put((Object)new ErrorStatus(this.ensureId(), "duplicate entityID: " + id));
                reported.add(id);
                continue;
            }
            ids.add(id);
        }
    }
}

