/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.SimpleDOMTraversalContext;
import net.shibboleth.metadata.dom.saml.AbstractSAMLTraversalStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@ThreadSafe
public class CRDetectionStage
extends AbstractSAMLTraversalStage<Context> {
    private static final char CR = '\r';

    @Override
    protected boolean applicable(@Nonnull Element element, @Nonnull Context context) {
        return true;
    }

    @Override
    protected void visit(@Nonnull Element element, @Nonnull Context context) throws StageProcessingException {
        if (context.hasError()) {
            return;
        }
        Item<Element> item = context.getItem();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3 || node.getNodeValue().indexOf(13) < 0) continue;
            this.addError(item, element, "element text content contains a carriage return character");
            context.setError();
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            Node attribute = attributes.item(index);
            if (attribute.getNodeValue().indexOf(13) < 0) continue;
            this.addError(item, element, "attribute value contains a carriage return character");
            context.setError();
            return;
        }
    }

    @Override
    @Nonnull
    protected Context buildContext(@Nonnull Item<Element> item) {
        return new Context(item);
    }

    protected static class Context
    extends SimpleDOMTraversalContext {
        private boolean error;

        public Context(@Nonnull Item<Element> contextItem) {
            super(contextItem);
        }

        public boolean hasError() {
            return this.error;
        }

        public void setError() {
            this.error = true;
        }
    }
}

