/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.ds;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.AbstractDOMValidationStage;
import net.shibboleth.metadata.dom.SimpleDOMTraversalContext;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.w3c.dom.Element;

@ThreadSafe
public class X509ValidationStage
extends AbstractDOMValidationStage<X509Certificate, Context> {
    @NonnullAfterInit
    @GuardedBy(value="this")
    private CertificateFactory factory;

    @Override
    @Nonnull
    protected Context buildContext(@Nonnull Item<Element> item) {
        return new Context(item);
    }

    @Override
    protected boolean applicable(@Nonnull Element e, @Nonnull Context context) {
        return "http://www.w3.org/2000/09/xmldsig#".equals(e.getNamespaceURI()) && "X509Certificate".equals(e.getLocalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visit(@Nonnull Element element, @Nonnull Context context) throws StageProcessingException {
        String text = element.getTextContent();
        assert (text != null);
        try {
            X509Certificate cert;
            byte[] data = Base64Support.decode((String)text);
            X509ValidationStage x509ValidationStage = this;
            synchronized (x509ValidationStage) {
                cert = (X509Certificate)this.factory.generateCertificate(new ByteArrayInputStream(data));
                assert (cert != null);
            }
            if (!context.haveSeen(cert)) {
                context.add(cert);
                this.applyValidators(cert, context);
            }
        }
        catch (CertificateException e) {
            this.addError(context.getItem(), element, "X.509 certificate: " + e.getMessage());
        }
        catch (DecodingException e) {
            this.addError(context.getItem(), element, "could not convert X509Certficate data");
        }
    }

    @Override
    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new ComponentInitializationException("can't create X.509 certificate factory", (Exception)e);
        }
    }

    protected static class Context
    extends SimpleDOMTraversalContext {
        private Map<X509Certificate, X509Certificate> certMap = new HashMap<X509Certificate, X509Certificate>();

        public Context(@Nonnull Item<Element> contextItem) {
            super(contextItem);
        }

        protected boolean haveSeen(@Nonnull X509Certificate cert) {
            return this.certMap.containsKey(cert);
        }

        protected void add(@Nonnull X509Certificate cert) {
            this.certMap.put(cert, cert);
        }
    }
}

