/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.AbstractNamespacesStrippingStage;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;

@ThreadSafe
public class NamespacesStrippingStage
extends AbstractNamespacesStrippingStage {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<String> namespaces = CollectionSupport.emptySet();
    @GuardedBy(value="this")
    private boolean keeping;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<String> getNamespaces() {
        return this.namespaces;
    }

    public synchronized void setNamespaces(@Nonnull @NonnullElements @Unmodifiable Collection<String> nss) {
        this.checkSetterPreconditions();
        this.namespaces = CollectionSupport.copyToSet(nss);
    }

    public final synchronized boolean isKeeping() {
        return this.keeping;
    }

    public synchronized void setKeeping(boolean keep) {
        this.checkSetterPreconditions();
        this.keeping = keep;
    }

    @Override
    protected boolean removingNamespace(@Nullable String namespace) {
        if (namespace == null) {
            return this.isKeeping();
        }
        return this.isKeeping() ^ this.getNamespaces().contains(namespace);
    }
}

