/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.AbstractNamespacesStrippingStage;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

@ThreadSafe
public class NamespaceStrippingStage
extends AbstractNamespacesStrippingStage {
    @NonnullAfterInit
    @NotEmpty
    @GuardedBy(value="this")
    private String namespace;

    @NonnullAfterInit
    public final synchronized String getNamespace() {
        return this.namespace;
    }

    public synchronized void setNamespace(@Nonnull @NotEmpty String ns) {
        this.checkSetterPreconditions();
        this.namespace = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)ns), (String)"target namespace can not be null or empty");
    }

    @Override
    protected boolean removingNamespace(@Nullable String ns) {
        return this.getNamespace().equals(ns);
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.namespace == null) {
            throw new ComponentInitializationException("target namespace can not be null or empty");
        }
    }
}

