/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.AbstractDOMTraversalStage;
import net.shibboleth.metadata.dom.SimpleDOMTraversalContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class ElementsStrippingStage
extends AbstractDOMTraversalStage<Context> {
    @NonnullAfterInit
    @NotEmpty
    @GuardedBy(value="this")
    private String elementNamespace;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<String> elementNames = CollectionSupport.emptySet();
    private boolean keeping;

    @NonnullAfterInit
    @NotEmpty
    public final synchronized String getElementNamespace() {
        return this.elementNamespace;
    }

    public void setElementNamespace(@Nonnull @NotEmpty String namespace) {
        this.checkSetterPreconditions();
        this.elementNamespace = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)namespace), (String)"target namespace can not be null or empty");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<String> getElementNames() {
        return this.elementNames;
    }

    public synchronized void setElementNames(@Nonnull @NonnullElements @Unmodifiable @NotEmpty Collection<String> names) {
        this.checkSetterPreconditions();
        this.elementNames = CollectionSupport.copyToSet(names);
    }

    public void setKeeping(boolean keep) {
        this.keeping = keep;
    }

    public boolean isKeeping() {
        return this.keeping;
    }

    @Override
    protected boolean applicable(@Nonnull Element element, @Nonnull Context context) {
        if (!context.getElementNamespace().equals(element.getNamespaceURI())) {
            return false;
        }
        return context.isKeeping() ^ context.getElementNames().contains(element.getLocalName());
    }

    @Override
    protected void visit(@Nonnull Element element, @Nonnull Context context) {
        context.add(element);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.elementNamespace == null) {
            throw new ComponentInitializationException("target namespace can not be null or empty");
        }
    }

    @Override
    @Nonnull
    protected synchronized Context buildContext(@Nonnull Item<Element> item) {
        String ns = this.getElementNamespace();
        assert (ns != null);
        return new Context(item, ns, this.getElementNames(), this.isKeeping());
    }

    @Immutable
    protected static final class Context
    extends SimpleDOMTraversalContext {
        @Nonnull
        @NonnullElements
        private final List<Element> elements = new ArrayList<Element>();
        @Nonnull
        @NotEmpty
        private final String elementNamespace;
        @Nonnull
        @NonnullElements
        @Unmodifiable
        private final Collection<String> elementNames;
        private final boolean keeping;

        public Context(@Nonnull Item<Element> contextItem, @Nonnull @NotEmpty String namespace, @Nonnull @NonnullElements @Unmodifiable Collection<String> names, boolean keep) {
            super(contextItem);
            this.elementNamespace = namespace;
            this.elementNames = names;
            this.keeping = keep;
        }

        @Nonnull
        protected final String getElementNamespace() {
            return this.elementNamespace;
        }

        protected final Collection<String> getElementNames() {
            return this.elementNames;
        }

        protected final boolean isKeeping() {
            return this.keeping;
        }

        protected void add(@Nonnull Element element) {
            this.elements.add(element);
        }

        @Override
        public void end() {
            for (Element element : this.elements) {
                element.getParentNode().removeChild(element);
            }
        }
    }
}

