/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.XMLParserException;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;

@ThreadSafe
public class DOMResourceSourceStage
extends AbstractStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(DOMResourceSourceStage.class);
    @NonnullAfterInit
    @GuardedBy(value="this")
    private Resource domResource;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private ParserPool parserPool;
    @GuardedBy(value="this")
    private boolean errorCausesSourceFailure = true;

    @Nullable
    public final synchronized Resource getDOMResource() {
        return this.domResource;
    }

    public synchronized void setDOMResource(@Nonnull Resource resource) {
        this.checkSetterPreconditions();
        this.domResource = (Resource)Constraint.isNotNull((Object)resource, (String)"DOM resource can not be null");
    }

    @NonnullAfterInit
    public final synchronized ParserPool getParserPool() {
        return this.parserPool;
    }

    public synchronized void setParserPool(@Nonnull ParserPool pool) {
        this.checkSetterPreconditions();
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"Parser pool can not be null");
    }

    public final synchronized boolean getErrorCausesSourceFailure() {
        return this.errorCausesSourceFailure;
    }

    public synchronized void setErrorCausesSourceFailure(boolean causesFailure) {
        this.checkSetterPreconditions();
        this.errorCausesSourceFailure = causesFailure;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<Element>> items) throws StageProcessingException {
        Resource resource = this.getDOMResource();
        assert (resource != null);
        LOG.debug("Attempting to fetch XML document from '{}'", (Object)resource.getDescription());
        try (InputStream ins = resource.getInputStream();){
            this.populateItemCollection(items, ins, resource);
        }
        catch (IOException e) {
            if (this.getErrorCausesSourceFailure()) {
                throw new StageProcessingException("Error retrieving XML document from " + resource.getDescription(), e);
            }
            LOG.warn("stage {}: unable to read in XML file", (Object)this.getId());
            LOG.debug("stage {}: HTTP resource exception", (Object)this.getId(), (Object)e);
        }
    }

    protected void populateItemCollection(@Nonnull @NonnullElements List<Item<Element>> items, @Nonnull InputStream data, @Nonnull Resource resource) throws StageProcessingException {
        try {
            LOG.debug("Parsing XML document retrieved from '{}'", (Object)resource.getDescription());
            items.add(new DOMElementItem(this.getParserPool().parse(data)));
        }
        catch (XMLParserException e) {
            if (this.getErrorCausesSourceFailure()) {
                throw new StageProcessingException(this.getId() + " unable to parse returned XML document " + resource.getDescription(), (Exception)((Object)e));
            }
            LOG.warn("stage {}: unable to parse XML document", (Object)this.getId());
            LOG.debug("stage {}: parsing exception", (Object)this.getId(), (Object)e);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", ParserPool may not be null");
        }
        if (this.domResource == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", either a DomResource must be specified");
        }
    }
}

