/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemCollectionSerializer;
import net.shibboleth.metadata.ItemSerializer;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.w3c.dom.Element;

@ThreadSafe
public class DOMElementSerializer
implements ItemSerializer<Element>,
ItemCollectionSerializer<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(DOMElementSerializer.class);

    @Override
    public void serialize(@Nonnull Item<Element> item, @Nonnull OutputStream output) throws IOException {
        Element documentRoot = item.unwrap();
        try {
            TransformerFactory tfac = TransformerFactory.newInstance();
            Transformer serializer = tfac.newTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.transform(new DOMSource(documentRoot.getOwnerDocument()), new StreamResult(output));
        }
        catch (TransformerException e) {
            LOG.error("Unable to write out XML", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void serializeCollection(@Nonnull @NonnullElements Collection<Item<Element>> items, @Nonnull OutputStream output) throws IOException {
        Iterator<Item<Element>> iter = items.iterator();
        if (iter.hasNext()) {
            Item<Element> item = iter.next();
            assert (item != null);
            this.serialize(item, output);
            if (iter.hasNext()) {
                LOG.warn("collection contained more than one Item; rest ignored");
            }
        } else {
            LOG.warn("collection was empty");
        }
    }
}

