/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.ClassToInstanceMultiMap;
import net.shibboleth.shared.logic.Constraint;

@NotThreadSafe
public abstract class AbstractItem<T>
implements Item<T> {
    @Nonnull
    private final T data;
    @Nonnull
    @NonnullElements
    private final ClassToInstanceMultiMap<ItemMetadata> metadata;

    protected AbstractItem(@Nonnull T newData) {
        Constraint.isNotNull(newData, (String)"data to wrap can not be null");
        this.metadata = new ClassToInstanceMultiMap(true);
        this.data = newData;
    }

    @Override
    @Nonnull
    public final T unwrap() {
        return this.data;
    }

    @Override
    @Nonnull
    @NonnullElements
    public final ClassToInstanceMultiMap<ItemMetadata> getItemMetadata() {
        return this.metadata;
    }
}

