/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.springframework.core.io.Resource;

public final class ResourceHelper
implements net.shibboleth.shared.resource.Resource {
    @Nonnull
    private Resource springResource;

    private ResourceHelper(@Nonnull Resource theResource) {
        this.springResource = (Resource)Constraint.isNotNull((Object)theResource, (String)"provided Spring Resource should not be null");
    }

    @Nonnull
    public static net.shibboleth.shared.resource.Resource of(@Nonnull @ParameterName(name="springResource") Resource springResource) {
        if (springResource instanceof net.shibboleth.shared.resource.Resource) {
            return (net.shibboleth.shared.resource.Resource)springResource;
        }
        return new ResourceHelper(springResource);
    }

    @Nonnull
    public InputStream getInputStream() throws IOException {
        return this.springResource.getInputStream();
    }

    public boolean exists() {
        return this.springResource.exists();
    }

    public boolean isFile() {
        return this.springResource.isFile();
    }

    public boolean isReadable() {
        return this.springResource.isReadable();
    }

    public boolean isOpen() {
        return this.springResource.isOpen();
    }

    @Nonnull
    public URL getURL() throws IOException {
        return this.springResource.getURL();
    }

    @Nonnull
    public URI getURI() throws IOException {
        return this.springResource.getURI();
    }

    @Nonnull
    public File getFile() throws IOException {
        return this.springResource.getFile();
    }

    public long contentLength() throws IOException {
        return this.springResource.contentLength();
    }

    public long lastModified() throws IOException {
        return this.springResource.lastModified();
    }

    @Nonnull
    public net.shibboleth.shared.resource.Resource createRelativeResource(@Nonnull String relativePath) throws IOException {
        return ResourceHelper.of(this.springResource.createRelative(relativePath));
    }

    public String getFilename() {
        return this.springResource.getFilename();
    }

    @Nonnull
    public String getDescription() {
        return this.springResource.getDescription();
    }
}

