/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.factory;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.factory.AbstractFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ViewResolver;

public class ViewResolversFactoryBean
extends AbstractFactoryBean<List<ViewResolver>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ViewResolversFactoryBean.class);
    @Nonnull
    private List<ViewResolver> resolvers;

    @Autowired
    public ViewResolversFactoryBean(@Nullable List<ViewResolver> freeObjects) {
        this.resolvers = freeObjects != null ? CollectionSupport.copyToList(freeObjects) : CollectionSupport.emptyList();
        this.log.debug("Registered ViewResolvers: {}", this.resolvers.stream().map(Object::getClass).map(Class::getName).collect(Collectors.toUnmodifiableList()));
    }

    @Override
    @Nullable
    public Class<List> getObjectType() {
        return List.class;
    }

    @Override
    @Nullable
    protected List<ViewResolver> createInstance() throws Exception {
        return CollectionSupport.copyToList(this.resolvers);
    }
}

