/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class SimpleCommandLineArguments {
    @Parameter
    private List<String> otherArgs = new ArrayList<String>();
    @Nullable
    private String inFile;
    @Nullable
    private String pipelineName;
    @Parameter(names={"--verbose"})
    private boolean verbose;
    @Parameter(names={"--quiet"})
    private boolean quiet;
    @Parameter(names={"--logConfig"})
    @Nullable
    private String logConfig;
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"--version"})
    private boolean version;

    public void parseCommandLineArguments(String[] args) {
        try {
            JCommander jc = new JCommander((Object)this);
            jc.parse(args);
            if (this.doHelp() || this.doVersion()) {
                return;
            }
            if (this.otherArgs.size() != 2) {
                this.printHelp(System.out);
                System.out.flush();
                System.exit(1);
            }
            this.inFile = this.otherArgs.get(0);
            this.pipelineName = this.otherArgs.get(1);
            this.validateCommandLineArguments();
        }
        catch (ParameterException e) {
            this.errorAndExit(e.getMessage());
        }
    }

    @Nullable
    public String getInputFile() {
        return this.inFile;
    }

    @Nullable
    public String getPipelineName() {
        return this.pipelineName;
    }

    public boolean doVerboseOutput() {
        return this.verbose;
    }

    public boolean doQuietOutput() {
        return this.quiet;
    }

    @Nullable
    public String getLoggingConfiguration() {
        return this.logConfig;
    }

    public boolean doHelp() {
        return this.help;
    }

    public boolean doVersion() {
        return this.version;
    }

    private void validateCommandLineArguments() {
        if (this.doVerboseOutput() && this.doQuietOutput()) {
            this.errorAndExit("Verbose and quiet output are mutually exclusive");
        }
    }

    public void printHelp(PrintStream out) {
        out.println("SimpleCommandLine");
        out.println("Provides a command line interface for the metadata aggregator.");
        out.println();
        out.println("   SimpleCommandLine [options] springConfiguration pipelineName");
        out.println();
        out.println("      springConfiguration      name of Spring configuration to use");
        out.println("      pipelineName             name of pipeline to invoke");
        out.println();
        out.println("==== Command Line Options ====");
        out.println();
        out.println(String.format("  --%-20s %s", "help", "Prints this help information"));
        out.println(String.format("  --%-20s %s", "version", "Prints aggregator framework version"));
        out.println();
        out.println("Logging Options - these options are mutually exclusive");
        out.println(String.format("  --%-20s %s", "verbose", "Turn on verbose messages."));
        out.println(String.format("  --%-20s %s", "quiet", "Restrict output messages to errors and warnings."));
        out.println();
        out.println(String.format("  --%-20s %s", "logConfig", "Specifies a logback configuration file to use to configure logging."));
        out.println();
    }

    private void errorAndExit(String error) {
        System.err.println(error);
        System.err.flush();
        System.out.println();
        this.printHelp(System.out);
        System.out.flush();
        System.exit(1);
    }
}

