/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.validate.BaseAsValidator;
import net.shibboleth.metadata.validate.Validator;

public class AsLiteralTailStringValidator
extends BaseAsValidator<String, String>
implements Validator<String> {
    private final Pattern pattern = Pattern.compile(".*?\\\\.(([a-zA-Z0-9-]+\\\\.)+[a-zA-Z0-9-]+)\\$");

    @Override
    @Nonnull
    protected String convert(@Nonnull String regex) throws IllegalArgumentException {
        Matcher matcher = this.pattern.matcher(regex);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        String result = matcher.group(1).replaceAll("\\\\", "");
        assert (result != null);
        return result;
    }
}

