/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.pipeline.AbstractItemMetadataSelectionStage;
import net.shibboleth.metadata.pipeline.TerminationException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.ClassToInstanceMultiMap;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class ItemMetadataTerminationStage<T>
extends AbstractItemMetadataSelectionStage<T, ItemMetadata> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(ItemMetadataTerminationStage.class);

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items, @Nonnull Item<T> matchingItem, @Nonnull @NonnullElements ClassToInstanceMultiMap<ItemMetadata> matchingMetadata) throws TerminationException {
        String itemId = this.getItemIdentificationStrategy().getItemIdentifier(matchingItem);
        LOG.error("Item {} caused processing to terminate because it was marked with a {}", (Object)itemId, (Object)matchingMetadata.keys());
        throw new TerminationException("Item " + itemId + " marked with metadata of type " + String.valueOf(matchingMetadata.keys()));
    }
}

