/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.Pipeline;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class CompositeStage<T>
extends AbstractStage<T>
implements Pipeline<T> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(CompositeStage.class);
    private static final boolean LOGGING_ALL_PROGRESS = Boolean.parseBoolean(System.getProperty("net.shibboleth.metadata.loggingAllProgress"));
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<Stage<T>> composedStages = CollectionSupport.emptyList();
    @GuardedBy(value="this")
    private boolean loggingProgress;

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<Stage<T>> getStages() {
        return this.composedStages;
    }

    public final synchronized void setStages(@Nonnull @NonnullElements @Unmodifiable List<Stage<T>> stages) {
        this.checkSetterPreconditions();
        this.composedStages = CollectionSupport.copyToList(stages);
    }

    public final synchronized boolean isLoggingProgress() {
        return this.loggingProgress;
    }

    public final synchronized void setLoggingProgress(boolean log) {
        this.checkSetterPreconditions();
        this.loggingProgress = log;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items) throws StageProcessingException {
        if (LOGGING_ALL_PROGRESS || this.isLoggingProgress()) {
            String id = this.getId();
            Instant start = Instant.now();
            for (Stage<T> stage : this.getStages()) {
                String stageId = stage.getId();
                Instant stageStart = Instant.now();
                LOG.info("{} >>> {}, count={}", new Object[]{id, stageId, items.size()});
                stage.execute(items);
                Instant stageEnd = Instant.now();
                Duration stageTime = Duration.between(stageStart, stageEnd);
                LOG.info("{} <<< {}, count={}, duration={}", new Object[]{id, stageId, items.size(), stageTime});
            }
            LOG.info("{} completed, duration={}", (Object)id, (Object)Duration.between(start, Instant.now()));
        } else {
            for (Stage<T> stage : this.getStages()) {
                stage.execute(items);
            }
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        for (Stage<T> stage : this.composedStages) {
            if (stage.isInitialized()) continue;
            stage.initialize();
        }
    }
}

