/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdattr;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.SAMLSupport;
import net.shibboleth.metadata.dom.saml.mdattr.MDAttrSupport;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthority;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntityAttributeFilteringStage
extends AbstractIteratingStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(EntityAttributeFilteringStage.class);
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<Predicate<EntityAttributeContext>> rules = CollectionSupport.emptyList();
    @GuardedBy(value="this")
    private boolean keeping = true;
    @GuardedBy(value="this")
    private boolean recordingRemovals;

    public synchronized void setRules(@Nonnull @NonnullElements @Unmodifiable List<Predicate<EntityAttributeContext>> newRules) {
        this.checkSetterPreconditions();
        this.rules = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(newRules, (String)"rules property may not be null")));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<Predicate<EntityAttributeContext>> getRules() {
        return this.rules;
    }

    public synchronized void setKeeping(boolean newValue) {
        this.checkSetterPreconditions();
        this.keeping = newValue;
    }

    public final synchronized boolean isKeeping() {
        return this.keeping;
    }

    public synchronized void setRecordingRemovals(boolean newValue) {
        this.checkSetterPreconditions();
        this.recordingRemovals = newValue;
    }

    public synchronized boolean isRecordingRemovals() {
        return this.recordingRemovals;
    }

    private boolean applyRules(EntityAttributeContext ctx) {
        for (Predicate<EntityAttributeContext> rule : this.getRules()) {
            if (!rule.test(ctx)) continue;
            return true;
        }
        return false;
    }

    private String extractRegistrationAuthority(@Nonnull Item<Element> item) {
        List regAuthList = item.getItemMetadata().get(RegistrationAuthority.class);
        if (regAuthList.isEmpty()) {
            return null;
        }
        return ((RegistrationAuthority)regAuthList.get(0)).getRegistrationAuthority();
    }

    private void filterAttribute(@Nonnull Element attribute, @Nullable String registrationAuthority, @Nonnull Item<Element> item) {
        String attributeName = attribute.getAttribute("Name");
        assert (attributeName != null);
        String attributeNameFormat = SAMLSupport.extractAttributeNameFormat(attribute);
        List attributeValues = ElementSupport.getChildElements((Node)attribute, (QName)SAMLSupport.ATTRIBUTE_VALUE_NAME);
        for (Element value : attributeValues) {
            String attributeValue = value.getTextContent();
            assert (attributeValue != null);
            ContextImpl ctx = new ContextImpl(attributeValue, attributeName, attributeNameFormat, registrationAuthority);
            boolean matched = this.applyRules(ctx);
            if (!(matched ^ this.isKeeping())) continue;
            LOG.debug("removing {}", (Object)ctx);
            if (this.isRecordingRemovals()) {
                item.getItemMetadata().put((Object)new WarningStatus(this.ensureId(), "removing '" + ctx.getName() + "' = '" + ctx.getValue() + "'"));
            }
            attribute.removeChild(value);
        }
    }

    private void filterEntityAttributes(@Nonnull Element entityAttributes, @Nullable String registrationAuthority, @Nonnull Item<Element> item) {
        List attributes = ElementSupport.getChildElements((Node)entityAttributes, (QName)SAMLSupport.ATTRIBUTE_NAME);
        for (Element attribute : attributes) {
            assert (attribute != null);
            this.filterAttribute(attribute, registrationAuthority, item);
            if (ElementSupport.getFirstChildElement((Node)attribute) != null) continue;
            LOG.debug("removing empty Attribute");
            entityAttributes.removeChild(attribute);
        }
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) {
        Element entity = item.unwrap();
        String registrationAuthority = this.extractRegistrationAuthority(item);
        for (Element entityAttributes : SAMLMetadataSupport.getDescriptorExtensionList(entity, MDAttrSupport.ENTITY_ATTRIBUTES_NAME)) {
            assert (entityAttributes != null);
            this.filterEntityAttributes(entityAttributes, registrationAuthority, item);
            if (ElementSupport.getFirstChildElement((Node)entityAttributes) != null) continue;
            LOG.debug("removing empty EntityAttributes");
            Node extensions = entityAttributes.getParentNode();
            extensions.removeChild(entityAttributes);
        }
    }

    @Immutable
    static class ContextImpl
    implements EntityAttributeContext {
        @Nonnull
        private final String value;
        @Nonnull
        private final String name;
        @Nonnull
        private final String nameFormat;
        @Nullable
        private final String registrationAuthority;

        public ContextImpl(@Nonnull String attributeValue, @Nonnull String attributeName, @Nonnull String attributeNameFormat, @Nullable String registrar) {
            this.value = (String)Constraint.isNotNull((Object)attributeValue, (String)"value may not be null");
            this.name = (String)Constraint.isNotNull((Object)attributeName, (String)"name may not be null");
            this.nameFormat = (String)Constraint.isNotNull((Object)attributeNameFormat, (String)"name format may not be null");
            this.registrationAuthority = registrar;
        }

        public ContextImpl(@Nonnull String attributeValue, @Nonnull String attributeName, @Nonnull String attributeNameFormat) {
            this(attributeValue, attributeName, attributeNameFormat, null);
        }

        @Override
        public String getRegistrationAuthority() {
            return this.registrationAuthority;
        }

        @Override
        @Nonnull
        public String getNameFormat() {
            return this.nameFormat;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        @Nonnull
        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("{v=").append(this.getValue());
            b.append(", n=").append(this.getName());
            b.append(", f=").append(this.getNameFormat());
            b.append(", r=");
            if (this.getRegistrationAuthority() == null) {
                b.append("(none)");
            } else {
                b.append(this.getRegistrationAuthority());
            }
            b.append('}');
            return b.toString();
        }
    }

    public static interface EntityAttributeContext {
        @Nullable
        public String getRegistrationAuthority();

        @Nonnull
        public String getNameFormat();

        @Nonnull
        public String getName();

        @Nonnull
        public String getValue();
    }
}

