/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdattr;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.Container;
import net.shibboleth.metadata.dom.ElementMatcher;
import net.shibboleth.metadata.dom.saml.AttributeElementMaker;
import net.shibboleth.metadata.dom.saml.AttributeElementMatcher;
import net.shibboleth.metadata.dom.saml.AttributeValueElementMaker;
import net.shibboleth.metadata.dom.saml.AttributeValueElementMatcher;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.SAMLSupport;
import net.shibboleth.metadata.dom.saml.mdattr.MDAttrSupport;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.w3c.dom.Element;

@ThreadSafe
public class EntityAttributeAddingStage
extends AbstractStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(EntityAttributeAddingStage.class);
    @Nonnull
    @GuardedBy(value="this")
    private String attributeName = "http://macedir.org/entity-category";
    @Nonnull
    @GuardedBy(value="this")
    private String attributeNameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri";
    @NonnullAfterInit
    @GuardedBy(value="this")
    private String attributeValue;
    @GuardedBy(value="this")
    private boolean addingFirstChild;

    @Nonnull
    public final synchronized String getAttributeName() {
        return this.attributeName;
    }

    public synchronized void setAttributeName(@Nonnull String name) {
        this.checkSetterPreconditions();
        this.attributeName = (String)Constraint.isNotNull((Object)name, (String)"attributeName must not be null");
    }

    @Nonnull
    public final synchronized String getAttributeNameFormat() {
        return this.attributeNameFormat;
    }

    public synchronized void setAttributeNameFormat(@Nonnull String nameFormat) {
        this.checkSetterPreconditions();
        this.attributeNameFormat = (String)Constraint.isNotNull((Object)nameFormat, (String)"attributeNameFormat must not be null");
    }

    @NonnullAfterInit
    public final synchronized String getAttributeValue() {
        return this.attributeValue;
    }

    public synchronized void setAttributeValue(@Nonnull String value) {
        this.checkSetterPreconditions();
        this.attributeValue = (String)Constraint.isNotNull((Object)value, (String)"attributeValue must not be null");
    }

    public final synchronized boolean isAddingFirstChild() {
        return this.addingFirstChild;
    }

    public synchronized void setAddingFirstChild(boolean addFirst) {
        this.checkSetterPreconditions();
        this.addingFirstChild = addFirst;
    }

    private boolean attributeValuePresent(@Nonnull List<Container> attributes, @Nonnull ElementMatcher matcher) {
        for (Container attribute : attributes) {
            if (attribute.findChild(matcher) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<Element>> items) {
        String name = this.getAttributeName();
        String format = this.getAttributeNameFormat();
        AttributeElementMatcher attributeMatcher = new AttributeElementMatcher(name, format);
        AttributeElementMaker attributeMaker = new AttributeElementMaker(name, format);
        String value = this.getAttributeValue();
        assert (value != null);
        AttributeValueElementMatcher attributeValueMatcher = new AttributeValueElementMatcher(value);
        AttributeValueElementMaker attributeValueMaker = new AttributeValueElementMaker(value);
        for (Item<Element> item : items) {
            Element entity = item.unwrap();
            if (!SAMLMetadataSupport.isEntityDescriptor(entity)) continue;
            Container entityContainer = new Container(entity);
            Container extensionsContainer = entityContainer.locateChild(SAMLSupport.EXTENSIONS_MATCHER, SAMLSupport.EXTENSIONS_MAKER, Container.FIRST_CHILD);
            Container attributesContainer = extensionsContainer.locateChild(MDAttrSupport.ENTITY_ATTRIBUTES_MATCHER, MDAttrSupport.ENTITY_ATTRIBUTES_MAKER, this.isAddingFirstChild() ? Container.FIRST_CHILD : Container.LAST_CHILD);
            List<Container> attributes = attributesContainer.findChildren(attributeMatcher);
            if (this.attributeValuePresent(attributes, attributeValueMatcher)) {
                LOG.debug("attribute value '{}' already present", (Object)value);
                return;
            }
            Container attribute = attributesContainer.locateChild(attributeMatcher, attributeMaker, Container.LAST_CHILD);
            attribute.addChild(attributeValueMaker, Container.LAST_CHILD);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeValue == null) {
            throw new ComponentInitializationException("attributeValue property must be supplied");
        }
    }
}

