/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.Type4UUIDIdentifierGenerationStrategy;
import net.shibboleth.shared.xml.AttributeSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ThreadSafe
public class GenerateIdStage
extends AbstractIteratingStage<Element> {
    @Nonnull
    public static final QName ID_ATTRIB = new QName("ID");
    @GuardedBy(value="this")
    @NonnullAfterInit
    private IdentifierGenerationStrategy generator;

    @NonnullAfterInit
    public synchronized IdentifierGenerationStrategy getGenerator() {
        return this.generator;
    }

    public synchronized void setGenerator(@Nonnull IdentifierGenerationStrategy newGenerator) {
        this.checkSetterPreconditions();
        this.generator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)newGenerator, (String)"ID generation strategy can not be null");
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element element = item.unwrap();
        if (!SAMLMetadataSupport.isEntityOrEntitiesDescriptor(element)) {
            return;
        }
        Attr idAttribute = AttributeSupport.getAttribute((Element)element, (QName)ID_ATTRIB);
        if (idAttribute == null) {
            Document ownerDocument = element.getOwnerDocument();
            assert (ownerDocument != null);
            idAttribute = AttributeSupport.constructAttribute((Document)ownerDocument, (QName)ID_ATTRIB);
            element.setAttributeNode(idAttribute);
        }
        idAttribute.setValue(this.getGenerator().generateIdentifier());
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.generator == null) {
            this.generator = new Type4UUIDIdentifierGenerationStrategy();
        }
    }
}

