/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.impl.XMLSignatureValidator;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SerializeSupport;
import org.apache.xml.security.Init;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class XMLSignatureValidationStage
extends AbstractStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(XMLSignatureValidationStage.class);
    @GuardedBy(value="this")
    private boolean signatureRequired = true;
    @GuardedBy(value="this")
    private boolean validSignatureRequired = true;
    @Nullable
    @GuardedBy(value="this")
    private Certificate verificationCertificate;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private PublicKey verificationKey;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<String> disallowedDigests = CollectionSupport.emptySet();
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<String> disallowedSignatureMethods = CollectionSupport.emptySet();
    @GuardedBy(value="this")
    private boolean permittingEmptyReferences = true;

    public final synchronized boolean isSignatureRequired() {
        return this.signatureRequired;
    }

    public synchronized void setSignatureRequired(boolean required) {
        this.checkSetterPreconditions();
        this.signatureRequired = required;
    }

    public final synchronized boolean isValidSignatureRequired() {
        return this.validSignatureRequired;
    }

    public synchronized void setValidSignatureRequired(boolean isRequired) {
        this.checkSetterPreconditions();
        this.validSignatureRequired = isRequired;
    }

    @Nullable
    public final synchronized Certificate getVerificationCertificate() {
        return this.verificationCertificate;
    }

    public synchronized void setVerificationCertificate(@Nonnull Certificate certificate) {
        this.checkSetterPreconditions();
        this.verificationCertificate = (Certificate)Constraint.isNotNull((Object)certificate, (String)"Certificate can not be null");
        this.verificationKey = this.verificationCertificate.getPublicKey();
    }

    @NonnullAfterInit
    public final synchronized PublicKey getVerificationKey() {
        return this.verificationKey;
    }

    public synchronized void setVerificationKey(@Nonnull PublicKey key) {
        this.checkSetterPreconditions();
        this.verificationKey = (PublicKey)Constraint.isNotNull((Object)key, (String)"Public key can not be null");
    }

    public synchronized void setDisallowedDigests(@Nonnull @NonnullElements @Unmodifiable Collection<String> identifiers) {
        this.checkSetterPreconditions();
        this.disallowedDigests = CollectionSupport.copyToSet(identifiers);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Set<String> getDisallowedDigests() {
        return this.disallowedDigests;
    }

    public synchronized void setDisallowedSignatureMethods(@Nonnull @NonnullElements @Unmodifiable Collection<String> identifiers) {
        this.checkSetterPreconditions();
        this.disallowedSignatureMethods = CollectionSupport.copyToSet(identifiers);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Set<String> getDisallowedSignatureMethods() {
        return this.disallowedSignatureMethods;
    }

    public final synchronized boolean isPermittingEmptyReferences() {
        return this.permittingEmptyReferences;
    }

    public synchronized void setPermittingEmptyReferences(boolean permit) {
        this.checkSetterPreconditions();
        this.permittingEmptyReferences = permit;
    }

    protected void validateItem(@Nonnull Item<Element> item, @Nonnull XMLSignatureValidator validator) {
        Element signatureElement;
        Element docElement = item.unwrap();
        try {
            signatureElement = validator.getSignatureElement(docElement);
            if (signatureElement == null) {
                if (this.isSignatureRequired()) {
                    LOG.debug("DOM Element was not signed and signature is required");
                    item.getItemMetadata().put((Object)new ErrorStatus(this.ensureId(), "DOM Element was not signed but signatures are required"));
                } else {
                    LOG.debug("DOM Element is not signed, no verification performed");
                }
                return;
            }
        }
        catch (XMLSignatureValidator.ValidationException e) {
            LOG.debug("setting status: ", (Object)e.getMessage());
            item.getItemMetadata().put((Object)new ErrorStatus(this.ensureId(), e.getMessage()));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("DOM Element contained Signature element\n{}", (Object)SerializeSupport.prettyPrintXML((Node)signatureElement));
        }
        try {
            validator.verifySignature(docElement, signatureElement);
        }
        catch (XMLSignatureValidator.ValidationException e) {
            String message = "element signature is invalid: " + e.getMessage();
            LOG.debug("setting status: ", (Object)message);
            if (this.isValidSignatureRequired()) {
                item.getItemMetadata().put((Object)new ErrorStatus(this.ensureId(), message));
            }
            item.getItemMetadata().put((Object)new WarningStatus(this.ensureId(), message));
        }
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<Element>> items) {
        PublicKey key = this.getVerificationKey();
        assert (key != null);
        XMLSignatureValidator validator = new XMLSignatureValidator(key, this.getDisallowedDigests(), this.getDisallowedSignatureMethods(), this.isPermittingEmptyReferences());
        for (Item<Element> item : items) {
            assert (item != null);
            this.validateItem(item, validator);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Init.init();
        if (this.verificationKey == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", no verification key was specified");
        }
    }
}

