/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SchemaBuilder;
import net.shibboleth.shared.xml.SerializeSupport;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@ThreadSafe
public class XMLSchemaValidationStage
extends AbstractIteratingStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(XMLSchemaValidationStage.class);
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<Resource> schemaResources = CollectionSupport.emptyList();
    @GuardedBy(value="this")
    private boolean elementRequiredToBeSchemaValid = true;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private Schema validationSchema;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<Resource> getSchemaResources() {
        return this.schemaResources;
    }

    public synchronized void setSchemaResources(@Nonnull @NonnullElements @Unmodifiable List<Resource> resources) {
        this.checkSetterPreconditions();
        this.schemaResources = CollectionSupport.copyToList(resources);
    }

    public final synchronized boolean isElementRequiredToBeSchemaValid() {
        return this.elementRequiredToBeSchemaValid;
    }

    public synchronized void setElementRequiredToBeSchemaValid(boolean isRequired) {
        this.checkSetterPreconditions();
        this.elementRequiredToBeSchemaValid = isRequired;
    }

    private synchronized Schema getValidationSchema() {
        return this.validationSchema;
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        LOG.debug("{} pipeline stage schema validating DOM Element collection elements", (Object)this.getId());
        Validator validator = this.getValidationSchema().newValidator();
        try {
            validator.validate(new DOMSource(item.unwrap()));
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DOM Element was not valid:\n{}", (Object)SerializeSupport.prettyPrintXML((Node)item.unwrap()), (Object)e);
            }
            if (this.isElementRequiredToBeSchemaValid()) {
                item.getItemMetadata().put((Object)new ErrorStatus(this.ensureId(), e.getMessage()));
            }
            item.getItemMetadata().put((Object)new WarningStatus(this.ensureId(), e.getMessage()));
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.schemaResources.isEmpty()) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", SchemaResources may not be empty");
        }
        try {
            LOG.debug("{} pipeline stage building validation schema resources", (Object)this.getId());
            SchemaBuilder builder = new SchemaBuilder();
            for (Resource schemaResource : this.schemaResources) {
                try {
                    builder.addSchema((Source)new StreamSource(schemaResource.getInputStream(), schemaResource.getDescription()));
                }
                catch (IOException e) {
                    throw new ComponentInitializationException("Unable to read schema resource " + schemaResource.getDescription(), (Exception)e);
                }
            }
            this.validationSchema = builder.buildSchema();
        }
        catch (SAXException e) {
            throw new ComponentInitializationException("Unable to generate schema", (Exception)e);
        }
    }
}

