/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import com.google.common.collect.ImmutableBiMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.NamespaceContext;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.primitive.StringSupport;

@ThreadSafe
public class SimpleNamespaceContext
implements NamespaceContext {
    private final ImmutableBiMap<String, String> mappings;

    public SimpleNamespaceContext() {
        this.mappings = this.getMappingsBuilder().build();
    }

    public SimpleNamespaceContext(@Nonnull @NonnullElements Map<String, String> prefixToUriMappings) {
        ImmutableBiMap.Builder<String, String> mappingBuilder = this.getMappingsBuilder();
        for (Map.Entry<String, String> entry : prefixToUriMappings.entrySet()) {
            String trimmedUri;
            String trimmedPrefix = StringSupport.trimOrNull((String)entry.getKey());
            if (trimmedPrefix == null || (trimmedUri = StringSupport.trimOrNull((String)entry.getValue())) == null) continue;
            mappingBuilder.put((Object)trimmedPrefix, (Object)trimmedUri);
        }
        this.mappings = mappingBuilder.build();
    }

    @Override
    @Nullable
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix can not be null");
        }
        String uri = (String)this.mappings.get((Object)prefix);
        if (uri == null) {
            return "";
        }
        return uri;
    }

    @Override
    @Nullable
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Namespace URI can not be null");
        }
        return (String)this.mappings.inverse().get((Object)namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Namespace URI can not be null");
        }
        String prefix = (String)this.mappings.inverse().get((Object)namespaceURI);
        if (prefix == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.singletonList(prefix).iterator();
    }

    @Nonnull
    private ImmutableBiMap.Builder<String, String> getMappingsBuilder() {
        ImmutableBiMap.Builder mappingBuilder = new ImmutableBiMap.Builder();
        mappingBuilder.put((Object)"xml", (Object)"http://www.w3.org/XML/1998/namespace");
        mappingBuilder.put((Object)"xmlns", (Object)"http://www.w3.org/2000/xmlns/");
        return mappingBuilder;
    }
}

