/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.dom.DOMTraversalContext;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.collection.ClassToInstanceMultiMap;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public abstract class AbstractDOMTraversalStage<C extends DOMTraversalContext>
extends AbstractIteratingStage<Element> {
    @Nonnull
    protected abstract C buildContext(@Nonnull Item<Element> var1);

    protected abstract boolean applicable(@Nonnull Element var1, @Nonnull C var2);

    protected abstract void visit(@Nonnull Element var1, @Nonnull C var2) throws StageProcessingException;

    private void traverse(@Nonnull Element element, @Nonnull C context) throws StageProcessingException {
        List children = ElementSupport.getChildElements((Node)element);
        for (Element child : children) {
            assert (child != null);
            this.traverse(child, context);
        }
        if (this.applicable(element, context)) {
            this.visit(element, context);
        }
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element docElement = item.unwrap();
        C context = this.buildContext(item);
        this.traverse(docElement, context);
        context.end();
    }

    @Nonnull
    protected String errorPrefix(@Nonnull Element element) {
        return "";
    }

    protected void addError(@Nonnull Item<Element> item, @Nonnull Element element, @Nonnull String error) {
        ClassToInstanceMultiMap<ItemMetadata> metadata = item.getItemMetadata();
        String prefix = this.errorPrefix(element);
        metadata.put((Object)new ErrorStatus(this.ensureId(), prefix + error));
    }
}

