/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Immutable
public abstract class StatusMetadata
implements ItemMetadata {
    @Nonnull
    @NotEmpty
    private final String component;
    @Nonnull
    @NotEmpty
    private final String message;

    public StatusMetadata(@Nonnull String componentId, String statusMessage) {
        this.component = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)componentId), (String)"Component ID can not be null or empty");
        this.message = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)statusMessage), (String)"Status message can not be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getComponentId() {
        return this.component;
    }

    @Nonnull
    @NotEmpty
    public String getStatusMessage() {
        return this.message;
    }
}

