/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemCollectionSerializer;
import net.shibboleth.metadata.ItemSerializer;
import net.shibboleth.shared.annotation.constraint.NonnullElements;

@Immutable
public class SimpleItemCollectionSerializer<T>
implements ItemCollectionSerializer<T> {
    private final ItemSerializer<T> serializer;

    public SimpleItemCollectionSerializer(@Nonnull ItemSerializer<T> ser) {
        this.serializer = ser;
    }

    @Override
    public void serializeCollection(@Nonnull @NonnullElements Collection<Item<T>> items, @Nonnull OutputStream output) throws IOException {
        for (Item<T> item : items) {
            assert (item != null);
            this.serializer.serialize(item, output);
        }
    }
}

