/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class DeduplicatingItemIdMergeStrategy
implements CollectionMergeStrategy {
    @Override
    public <T> void merge(@Nonnull @NonnullElements List<Item<T>> target, @Nonnull @NonnullElements List<List<Item<T>>> sources) {
        Constraint.isNotNull(target, (String)"Target collection can not be null");
        Constraint.isNotNull(sources, (String)"Source collections can not be null or empty");
        HashSet<ItemId> presentItemIds = new HashSet<ItemId>();
        for (Item<T> item : target) {
            presentItemIds.addAll(item.getItemMetadata().get(ItemId.class));
        }
        for (List list : sources) {
            assert (list != null);
            this.merge(presentItemIds, target, list);
        }
    }

    private <T> void merge(@Nonnull @NonnullElements HashSet<ItemId> presentItemIds, @Nonnull @NonnullElements List<Item<T>> target, @Nonnull @NonnullElements List<Item<T>> sourceItems) {
        for (Item<T> sourceItem : sourceItems) {
            List itemIds = sourceItem.getItemMetadata().get(ItemId.class);
            if (itemIds.isEmpty()) {
                target.add(sourceItem);
                continue;
            }
            boolean itemAlreadyPresent = false;
            for (ItemId itemId : itemIds) {
                if (!presentItemIds.contains(itemId)) continue;
                itemAlreadyPresent = true;
                break;
            }
            if (itemAlreadyPresent) continue;
            target.add(sourceItem);
            presentItemIds.addAll(itemIds);
        }
    }
}

