/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemIdentificationStrategy;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

@ThreadSafe
public abstract class AbstractCompositeItemIdentificationStrategy<T>
implements ItemIdentificationStrategy<T> {
    @Nonnull
    @NotEmpty
    @GuardedBy(value="this")
    private String noItemIdIdentifier = "unidentified";

    @Nonnull
    @NotEmpty
    public final synchronized String getNoItemIdIdentifier() {
        return this.noItemIdIdentifier;
    }

    public synchronized void setNoItemIdIdentifier(@Nonnull @NotEmpty String identifier) {
        this.noItemIdIdentifier = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)identifier), (String)"Identifier can not be null or empty");
    }

    @Nullable
    abstract String getBasicIdentifier(@Nonnull Item<T> var1);

    @Nullable
    abstract String getExtraIdentifier(@Nonnull Item<T> var1);

    @Override
    @Nonnull
    public String getItemIdentifier(@Nonnull Item<T> item) {
        Constraint.isNotNull(item, (String)"Item can not equal null");
        StringBuilder res = new StringBuilder();
        String basic = this.getBasicIdentifier(item);
        if (basic == null) {
            res.append(this.getNoItemIdIdentifier());
        } else {
            res.append(basic);
        }
        String extra = this.getExtraIdentifier(item);
        if (extra != null) {
            res.append(" (");
            res.append(extra);
            res.append(")");
        }
        String result = res.toString();
        assert (result != null);
        return result;
    }
}

