/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.config;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class DeprecatedBeanDetector
implements ApplicationListener<ContextRefreshedEvent> {
    @Nullable
    private final String warnContext;
    @Nonnull
    private final Map<String, String> beanNames;

    public DeprecatedBeanDetector(@Nonnull Map<String, String> map, @Nullable String logContext) {
        this.beanNames = new HashMap<String, String>(map.size());
        map.forEach((k, v) -> {
            String key = StringSupport.trimOrNull((String)k);
            String val = StringSupport.trimOrNull((String)v);
            if (key != null) {
                this.beanNames.put(key, val);
            }
        });
        this.warnContext = logContext;
    }

    public void onApplicationEvent(@Nonnull ContextRefreshedEvent event) {
        ApplicationContext applicationContext = (ApplicationContext)event.getSource();
        this.beanNames.forEach((k, v) -> {
            assert (k != null);
            if (applicationContext.containsLocalBean(k)) {
                DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.BEAN, (String)k, (String)this.warnContext, (String)v);
            }
        });
    }
}

