/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.util;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

@Immutable
public class RegexFileFilter
implements FileFilter {
    private final Pattern pattern;

    public RegexFileFilter(@Nonnull @NotEmpty String regex) {
        this.pattern = Pattern.compile((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)regex), (String)"regex pattern argument may not be null or empty"));
    }

    @Override
    public boolean accept(File pathname) {
        return this.pattern.matcher(pathname.getName()).matches();
    }
}

