/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline.impl;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public final class FutureSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(FutureSupport.class);

    private FutureSupport() {
    }

    @Nonnull
    public static <T> List<Item<T>> futureItems(@Nonnull Future<List<Item<T>>> future) throws StageProcessingException {
        try {
            List<Item<T>> value = future.get();
            if (value == null) {
                throw new StageProcessingException("null returned from future value");
            }
            return value;
        }
        catch (ExecutionException e) {
            LOG.debug("Pipeline threw an unexpected exception", (Throwable)e);
            if (e.getCause() instanceof StageProcessingException) {
                throw (StageProcessingException)e.getCause();
            }
            throw new StageProcessingException("ExecutionException during processing", e);
        }
        catch (InterruptedException e) {
            LOG.debug("Execution service was interrupted", (Throwable)e);
            throw new StageProcessingException("Execution service was interrupted", e);
        }
    }
}

